/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import processing.app.Base;
import processing.app.Editor;
import processing.app.syntax.SyntaxStyle;
import processing.core.PApplet;
import processing.core.PConstants;

public class Preferences {
    static final String PREFS_FILE = "preferences.txt";
    static final String PROMPT_YES = "Yes";
    static final String PROMPT_NO = "No";
    static final String PROMPT_CANCEL = "Cancel";
    static final String PROMPT_OK = "OK";
    static final String PROMPT_BROWSE = "Browse";
    public static int BUTTON_WIDTH = 80;
    public static int BUTTON_HEIGHT = 24;
    static final int GRID_SIZE = 33;
    static final int GUI_BIG = 13;
    static final int GUI_BETWEEN = 10;
    static final int GUI_SMALL = 6;
    JFrame dialog = new JFrame("Preferences");
    int wide;
    int high;
    JTextField sketchbookLocationField;
    JCheckBox exportSeparateBox;
    JCheckBox deletePreviousBox;
    JCheckBox externalEditorBox;
    JCheckBox memoryOverrideBox;
    JTextField memoryField;
    JCheckBox checkUpdatesBox;
    JTextField fontSizeField;
    JCheckBox autoAssociateBox;
    Editor editor;
    static Hashtable defaults;
    static Hashtable table;
    static File preferencesFile;

    protected static void init(String string) {
        try {
            Preferences.load(Base.getLibStream(PREFS_FILE));
        }
        catch (Exception exception) {
            Base.showError(null, "Could not read default settings.\nYou'll need to reinstall Processing.", exception);
        }
        String string2 = "." + PConstants.platformNames[PApplet.platform];
        int n = string2.length();
        Enumeration enumeration = table.keys();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            if (!string3.endsWith(string2)) continue;
            String string4 = string3.substring(0, string3.length() - n);
            String string5 = Preferences.get(string3);
            table.put(string4, string5);
        }
        defaults = (Hashtable)table.clone();
        Preferences.setColor("run.window.bgcolor", SystemColor.control);
        if (string != null) {
            try {
                Preferences.load(new FileInputStream(string));
            }
            catch (Exception exception) {
                Base.showError("Error", "Could not read preferences from " + string, exception);
            }
        } else if (!Base.isCommandLine()) {
            preferencesFile = Base.getSettingsFile(PREFS_FILE);
            if (!preferencesFile.exists()) {
                Preferences.save();
            } else {
                try {
                    Preferences.load(new FileInputStream(preferencesFile));
                }
                catch (Exception exception) {
                    Base.showError("Error reading preferences", "Error reading the preferences file. Please delete (or move)\n" + preferencesFile.getAbsolutePath() + " and restart Processing.", exception);
                }
            }
        }
    }

    public Preferences() {
        this.dialog.setResizable(false);
        Container container = this.dialog.getContentPane();
        container.setLayout(null);
        int n = 13;
        int n2 = 13;
        int n3 = 0;
        JLabel jLabel = new JLabel("Sketchbook location:");
        container.add(jLabel);
        Dimension dimension = jLabel.getPreferredSize();
        jLabel.setBounds(n2, n, dimension.width, dimension.height);
        n += dimension.height;
        this.sketchbookLocationField = new JTextField(40);
        container.add(this.sketchbookLocationField);
        dimension = this.sketchbookLocationField.getPreferredSize();
        JButton jButton = new JButton(PROMPT_BROWSE);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                File file = new File(Preferences.this.sketchbookLocationField.getText());
                File file2 = Base.selectFolder("Select new sketchbook location", file, Preferences.this.dialog);
                if (file2 != null) {
                    Preferences.this.sketchbookLocationField.setText(file2.getAbsolutePath());
                }
            }
        });
        container.add(jButton);
        Dimension dimension2 = jButton.getPreferredSize();
        int n4 = Math.max(dimension.height, dimension2.height);
        this.sketchbookLocationField.setBounds(n2, n + (n4 - dimension.height) / 2, dimension.width, dimension.height);
        int n5 = n2 + dimension.width + 6;
        jButton.setBounds(n5, n + (n4 - dimension2.height) / 2, dimension2.width, dimension2.height);
        n3 = Math.max(n3, n5 + dimension2.width + 13);
        n += n4 + 10;
        Box box = Box.createHorizontalBox();
        jLabel = new JLabel("Editor font size: ");
        box.add(jLabel);
        this.fontSizeField = new JTextField(4);
        box.add(this.fontSizeField);
        jLabel = new JLabel("  (requires restart of Processing)");
        box.add(jLabel);
        container.add(box);
        dimension = ((Container)box).getPreferredSize();
        box.setBounds(n2, n, dimension.width, dimension.height);
        Font font = Preferences.getFont("editor.font");
        this.fontSizeField.setText(String.valueOf(font.getSize()));
        n += dimension.height + 10;
        Box box2 = Box.createHorizontalBox();
        this.memoryOverrideBox = new JCheckBox("Increase maximum available memory to ");
        box2.add(this.memoryOverrideBox);
        this.memoryField = new JTextField(4);
        box2.add(this.memoryField);
        box2.add(new JLabel(" MB"));
        container.add(box2);
        dimension = ((Container)box2).getPreferredSize();
        box2.setBounds(n2, n, dimension.width, dimension.height);
        this.exportSeparateBox = new JCheckBox("Use multiple .jar files when exporting applets (ignored when using libraries)");
        container.add(this.exportSeparateBox);
        dimension = this.exportSeparateBox.getPreferredSize();
        this.exportSeparateBox.setBounds(n2, n += dimension.height + 10, dimension.width + 10, dimension.height);
        n3 = Math.max(n3, n2 + dimension.width);
        this.deletePreviousBox = new JCheckBox("Delete previous applet or application folder on export");
        container.add(this.deletePreviousBox);
        dimension = this.deletePreviousBox.getPreferredSize();
        this.deletePreviousBox.setBounds(n2, n += dimension.height + 10, dimension.width + 10, dimension.height);
        n3 = Math.max(n3, n2 + dimension.width);
        this.externalEditorBox = new JCheckBox("Use external editor");
        container.add(this.externalEditorBox);
        dimension = this.externalEditorBox.getPreferredSize();
        this.externalEditorBox.setBounds(n2, n += dimension.height + 10, dimension.width + 10, dimension.height);
        n3 = Math.max(n3, n2 + dimension.width);
        this.checkUpdatesBox = new JCheckBox("Check for updates on startup");
        container.add(this.checkUpdatesBox);
        dimension = this.checkUpdatesBox.getPreferredSize();
        this.checkUpdatesBox.setBounds(n2, n += dimension.height + 10, dimension.width + 10, dimension.height);
        n3 = Math.max(n3, n2 + dimension.width);
        n += dimension.height + 10;
        if (Base.isWindows()) {
            this.autoAssociateBox = new JCheckBox("Automatically associate .pde files with Processing");
            container.add(this.autoAssociateBox);
            dimension = this.autoAssociateBox.getPreferredSize();
            this.autoAssociateBox.setBounds(n2, n, dimension.width + 10, dimension.height);
            n3 = Math.max(n3, n2 + dimension.width);
            n += dimension.height + 10;
        }
        jLabel = new JLabel("More preferences can be edited directly in the file");
        container.add(jLabel);
        dimension = jLabel.getPreferredSize();
        jLabel.setForeground(Color.gray);
        jLabel.setBounds(n2, n, dimension.width, dimension.height);
        n3 = Math.max(n3, n2 + dimension.width);
        n += dimension.height;
        final JLabel jLabel2 = jLabel = new JLabel(preferencesFile.getAbsolutePath());
        jLabel.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                Base.openFolder(Base.getSettingsFolder());
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                jLabel2.setForeground(new Color(0, 0, 140));
            }

            public void mouseExited(MouseEvent mouseEvent) {
                jLabel2.setForeground(Color.BLACK);
            }
        });
        container.add(jLabel);
        dimension = jLabel.getPreferredSize();
        jLabel.setBounds(n2, n, dimension.width, dimension.height);
        n3 = Math.max(n3, n2 + dimension.width);
        n += dimension.height;
        jLabel = new JLabel("(edit only when Processing is not running)");
        container.add(jLabel);
        dimension = jLabel.getPreferredSize();
        jLabel.setForeground(Color.gray);
        jLabel.setBounds(n2, n, dimension.width, dimension.height);
        n3 = Math.max(n3, n2 + dimension.width);
        n += dimension.height;
        jButton = new JButton(PROMPT_OK);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Preferences.this.applyFrame();
                Preferences.this.disposeFrame();
            }
        });
        container.add(jButton);
        dimension2 = jButton.getPreferredSize();
        BUTTON_HEIGHT = dimension2.height;
        n5 = n3 - (BUTTON_WIDTH + 6 + BUTTON_WIDTH);
        jButton.setBounds(n5, n, BUTTON_WIDTH, BUTTON_HEIGHT);
        jButton = new JButton(PROMPT_CANCEL);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Preferences.this.disposeFrame();
            }
        });
        container.add(jButton);
        jButton.setBounds(n5 += BUTTON_WIDTH + 6, n, BUTTON_WIDTH, BUTTON_HEIGHT);
        this.wide = n3 + 13;
        this.high = (n += BUTTON_HEIGHT + 10) + 6;
        this.dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Preferences.this.disposeFrame();
            }
        });
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Preferences.this.disposeFrame();
            }
        };
        Base.registerWindowCloseKeys(this.dialog.getRootPane(), actionListener);
        Base.setIcon(this.dialog);
        Dimension dimension3 = Toolkit.getDefaultToolkit().getScreenSize();
        this.dialog.setLocation((dimension3.width - this.wide) / 2, (dimension3.height - this.high) / 2);
        this.dialog.pack();
        Insets insets = this.dialog.getInsets();
        this.dialog.setSize(this.wide + insets.left + insets.right, this.high + insets.top + insets.bottom);
        container.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                KeyStroke keyStroke = Editor.WINDOW_CLOSE_KEYSTROKE;
                if (keyEvent.getKeyCode() == 27 || KeyStroke.getKeyStrokeForEvent(keyEvent).equals(keyStroke)) {
                    Preferences.this.disposeFrame();
                }
            }
        });
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.wide, this.high);
    }

    protected void disposeFrame() {
        this.dialog.dispose();
    }

    protected void applyFrame() {
        Preferences.setBoolean("export.applet.separate_jar_files", this.exportSeparateBox.isSelected());
        Preferences.setBoolean("export.delete_target_folder", this.deletePreviousBox.isSelected());
        String string = Preferences.get("sketchbook.path");
        String string2 = this.sketchbookLocationField.getText();
        if (!string2.equals(string)) {
            this.editor.base.rebuildSketchbookMenus();
            Preferences.set("sketchbook.path", string2);
        }
        Preferences.setBoolean("editor.external", this.externalEditorBox.isSelected());
        Preferences.setBoolean("update.check", this.checkUpdatesBox.isSelected());
        Preferences.setBoolean("run.options.memory", this.memoryOverrideBox.isSelected());
        int n = Preferences.getInteger("run.options.memory.initial");
        int n2 = Preferences.getInteger("run.options.memory.maximum");
        try {
            n2 = Integer.parseInt(this.memoryField.getText().trim());
            if (n2 < n) {
                n2 = n;
            }
            Preferences.setInteger("run.options.memory.maximum", n2);
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("Ignoring bad memory setting");
        }
        String string3 = this.fontSizeField.getText();
        try {
            int n3 = Integer.parseInt(string3.trim());
            String[] stringArray = PApplet.split((String)Preferences.get("editor.font"), (char)',');
            stringArray[2] = String.valueOf(n3);
            Preferences.set("editor.font", PApplet.join((String[])stringArray, (char)','));
        }
        catch (Exception exception) {
            System.err.println("ignoring invalid font size " + string3);
        }
        if (this.autoAssociateBox != null) {
            Preferences.setBoolean("platform.auto_file_type_associations", this.autoAssociateBox.isSelected());
        }
        this.editor.applyPreferences();
    }

    protected void showFrame(Editor editor) {
        this.editor = editor;
        this.exportSeparateBox.setSelected(Preferences.getBoolean("export.applet.separate_jar_files"));
        this.deletePreviousBox.setSelected(Preferences.getBoolean("export.delete_target_folder"));
        this.sketchbookLocationField.setText(Preferences.get("sketchbook.path"));
        this.externalEditorBox.setSelected(Preferences.getBoolean("editor.external"));
        this.checkUpdatesBox.setSelected(Preferences.getBoolean("update.check"));
        this.memoryOverrideBox.setSelected(Preferences.getBoolean("run.options.memory"));
        this.memoryField.setText(Preferences.get("run.options.memory.maximum"));
        if (this.autoAssociateBox != null) {
            this.autoAssociateBox.setSelected(Preferences.getBoolean("platform.auto_file_type_associations"));
        }
        this.dialog.setVisible(true);
    }

    protected static void load(InputStream inputStream) throws IOException {
        String[] stringArray;
        for (String string : stringArray = PApplet.loadStrings((InputStream)inputStream)) {
            int n;
            if (string.length() == 0 || string.charAt(0) == '#' || (n = string.indexOf(61)) == -1) continue;
            String string2 = string.substring(0, n).trim();
            String string3 = string.substring(n + 1).trim();
            table.put(string2, string3);
        }
    }

    protected static void save() {
        if (preferencesFile == null) {
            return;
        }
        PrintWriter printWriter = PApplet.createWriter((File)preferencesFile);
        Enumeration enumeration = table.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            printWriter.println(string + "=" + (String)table.get(string));
        }
        printWriter.flush();
        printWriter.close();
    }

    public static String get(String string) {
        return (String)table.get(string);
    }

    public static String getDefault(String string) {
        return (String)defaults.get(string);
    }

    public static void set(String string, String string2) {
        table.put(string, string2);
    }

    public static boolean getBoolean(String string) {
        String string2 = Preferences.get(string);
        return new Boolean(string2);
    }

    public static void setBoolean(String string, boolean bl) {
        Preferences.set(string, bl ? "true" : "false");
    }

    public static int getInteger(String string) {
        return Integer.parseInt(Preferences.get(string));
    }

    public static void setInteger(String string, int n) {
        Preferences.set(string, String.valueOf(n));
    }

    public static Color getColor(String string) {
        Color color = Color.GRAY;
        String string2 = Preferences.get(string);
        if (string2 != null && string2.indexOf("#") == 0) {
            try {
                color = new Color(Integer.parseInt(string2.substring(1), 16));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return color;
    }

    public static void setColor(String string, Color color) {
        Preferences.set(string, "#" + PApplet.hex((int)(color.getRGB() & 0xFFFFFF), (int)6));
    }

    public static Font getFont(String string) {
        String[] stringArray;
        boolean bl = false;
        String string2 = Preferences.get(string);
        if (string2 == null) {
            string2 = Preferences.getDefault(string);
            bl = true;
        }
        if ((stringArray = PApplet.split((String)string2, (char)',')).length != 3) {
            string2 = Preferences.getDefault(string);
            stringArray = PApplet.split((String)string2, (char)',');
            bl = true;
        }
        String string3 = stringArray[0];
        int n = 0;
        if (stringArray[1].indexOf("bold") != -1) {
            n |= 1;
        }
        if (stringArray[1].indexOf("italic") != -1) {
            n |= 2;
        }
        int n2 = PApplet.parseInt((String)stringArray[2], (int)12);
        Font font = new Font(string3, n, n2);
        if (bl) {
            Preferences.set(string, string2);
        }
        return font;
    }

    public static SyntaxStyle getStyle(String string) {
        String string2 = Preferences.get("editor." + string + ".style");
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        String string3 = stringTokenizer.nextToken();
        if (string3.indexOf("#") == 0) {
            string3 = string3.substring(1);
        }
        Color color = Color.DARK_GRAY;
        try {
            color = new Color(Integer.parseInt(string3, 16));
        }
        catch (Exception exception) {
            // empty catch block
        }
        string3 = stringTokenizer.nextToken();
        boolean bl = string3.indexOf("bold") != -1;
        boolean bl2 = string3.indexOf("italic") != -1;
        return new SyntaxStyle(color, bl2, bl);
    }

    static {
        table = new Hashtable();
    }
}

