/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import processing.app.Base;
import processing.app.Preferences;
import processing.app.Sketch;
import processing.app.debug.Runner;
import processing.app.debug.RunnerException;
import processing.app.debug.RunnerListener;
import processing.core.PApplet;

public class Commander
implements RunnerListener {
    static final String helpArg = "--help";
    static final String preprocArg = "--preprocess";
    static final String buildArg = "--build";
    static final String runArg = "--run";
    static final String presentArg = "--present";
    static final String sketchArg = "--sketch=";
    static final String outputArg = "--output=";
    static final String exportAppletArg = "--export-applet";
    static final String exportApplicationArg = "--export-application";
    static final String platformArg = "--platform=";
    static final String preferencesArg = "--preferences=";
    static final int HELP = -1;
    static final int PREPROCESS = 0;
    static final int BUILD = 1;
    static final int RUN = 2;
    static final int PRESENT = 3;
    static final int EXPORT_APPLET = 4;
    static final int EXPORT_APPLICATION = 5;
    Sketch sketch;

    public static void main(String[] stringArray) {
        Base.setCommandLine();
        Base.initPlatform();
        Base.initRequirements();
        new Commander(stringArray);
    }

    public Commander(String[] stringArray) {
        Object object;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        int n = PApplet.platform;
        int n2 = -1;
        Object object2 = stringArray;
        int n3 = ((String[])object2).length;
        for (int i = 0; i < n3; ++i) {
            Object object3;
            object = object2[i];
            if (((String)object).length() == 0 || ((String)object).equals(helpArg)) continue;
            if (((String)object).equals(buildArg)) {
                n2 = 1;
                continue;
            }
            if (((String)object).equals(runArg)) {
                n2 = 2;
                continue;
            }
            if (((String)object).equals(presentArg)) {
                n2 = 3;
                continue;
            }
            if (((String)object).equals(preprocArg)) {
                n2 = 0;
                continue;
            }
            if (((String)object).equals(exportAppletArg)) {
                n2 = 4;
                continue;
            }
            if (((String)object).equals(exportApplicationArg)) {
                n2 = 5;
                continue;
            }
            if (((String)object).startsWith(platformArg)) {
                object3 = ((String)object).substring(platformArg.length());
                n = Base.getPlatformIndex((String)object3);
                if (n != -1) continue;
                Commander.complainAndQuit((String)object3 + " should instead be " + "'windows', 'macosx', or 'linux'.");
                continue;
            }
            if (((String)object).startsWith(sketchArg)) {
                string = ((String)object).substring(sketchArg.length());
                object3 = new File(string);
                File file = new File((File)object3, ((File)object3).getName() + ".pde");
                string2 = file.getAbsolutePath();
                continue;
            }
            if (((String)object).startsWith(outputArg)) {
                string3 = ((String)object).substring(outputArg.length());
                continue;
            }
            Commander.complainAndQuit("I don't know anything about " + (String)object + ".");
        }
        if (string3 == null && (n2 == 0 || n2 == 1 || n2 == 2 || n2 == 3)) {
            Commander.complainAndQuit("An output path must be specified when using --preprocess, --build, --run, or --present.");
        }
        if (n2 == -1) {
            Commander.printCommandLine(System.out);
            System.exit(0);
        }
        if (!((File)(object2 = new File(string3))).exists() && !((File)object2).mkdirs()) {
            Commander.complainAndQuit("Could not create the output folder.");
        }
        Preferences.init(string4);
        if (string == null) {
            Commander.complainAndQuit("No sketch path specified.");
        } else if (string3.equals(string2)) {
            Commander.complainAndQuit("The sketch path and output path cannot be identical.");
        } else if (!string2.toLowerCase().endsWith(".pde")) {
            Commander.complainAndQuit("Sketch path must point to the main .pde file.");
        } else {
            n3 = 0;
            try {
                this.sketch = new Sketch(null, string2);
                if (n2 == 0) {
                    n3 = this.sketch.preprocess(string3) != null ? 1 : 0;
                } else if (n2 == 1) {
                    n3 = this.sketch.build(string3) != null ? 1 : 0;
                } else if (n2 == 2 || n2 == 3) {
                    String string5 = this.sketch.build(string3);
                    if (string5 != null) {
                        n3 = 1;
                        object = new Runner(this.sketch, string5, n2 == 3, this);
                        ((Runner)object).launch();
                    } else {
                        n3 = 0;
                    }
                } else if (n2 == 4) {
                    if (string3 != null) {
                        n3 = this.sketch.exportApplet(string3) ? 1 : 0;
                    } else {
                        String string6 = string + File.separatorChar + "applet";
                        n3 = this.sketch.exportApplet(string6) ? 1 : 0;
                    }
                } else if (n2 == 5) {
                    if (string3 != null) {
                        n3 = this.sketch.exportApplication(string3, n) ? 1 : 0;
                    } else {
                        string3 = string + File.separatorChar + "application." + Base.getPlatformName(n);
                        n3 = this.sketch.exportApplication(string3, n) ? 1 : 0;
                    }
                }
                System.exit(n3 != 0 ? 0 : 1);
            }
            catch (RunnerException runnerException) {
                this.statusError(runnerException);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                System.exit(1);
            }
        }
    }

    public void statusError(String string) {
        System.err.println(string);
    }

    public void statusError(Exception exception) {
        if (exception instanceof RunnerException) {
            RunnerException runnerException = (RunnerException)exception;
            String string = this.sketch.getCode(runnerException.getCodeIndex()).getFileName();
            int n = runnerException.getCodeLine();
            int n2 = runnerException.getCodeColumn();
            if (n2 == -1) {
                n2 = 0;
            }
            System.err.println(string + ":" + n + ":" + n2 + ":" + n + ":" + n2 + ":" + " " + runnerException.getMessage());
        } else {
            exception.printStackTrace();
        }
    }

    static void complainAndQuit(String string) {
        Commander.printCommandLine(System.err);
        System.err.println(string);
        System.exit(1);
    }

    static void printCommandLine(PrintStream printStream) {
        printStream.println("Processing " + Base.VERSION_NAME + " rocks the console.");
        printStream.println();
        printStream.println("--help               Show this help text.");
        printStream.println();
        printStream.println("--sketch=<name>      Specify the sketch folder (required)");
        printStream.println("--output=<name>      Specify the output folder (required and");
        printStream.println("                     cannot be the same as the sketch folder.)");
        printStream.println();
        printStream.println("--preprocess         Preprocess a sketch into .java files.");
        printStream.println("--build              Preprocess and compile a sketch into .class files.");
        printStream.println("--run                Preprocess, compile, and run a sketch.");
        printStream.println("--present            Preprocess, compile, and run a sketch full screen.");
        printStream.println();
        printStream.println("--export-applet      Export an applet.");
        printStream.println("--export-application Export an application.");
        printStream.println("--platform           Specify the platform (export to application only).");
        printStream.println("                     Should be one of 'windows', 'macosx', or 'linux'.");
        printStream.println();
        printStream.println("--preferences=<file> Specify a preferences file to use (optional).");
    }
}

