/*
 * Decompiled with CFR 0.152.
 */
package processing.app.windows;

import java.io.File;
import java.io.UnsupportedEncodingException;
import processing.app.Base;
import processing.app.Preferences;
import processing.app.windows.Registry;
import processing.core.PApplet;

public class Platform
extends processing.app.Platform {
    static final String openCommand = System.getProperty("user.dir").replace('/', '\\') + "\\processing.exe \"%1\"";
    static final String DOC = "Processing.Document";

    public void init(Base base) {
        super.init(base);
        this.checkAssociations();
        this.checkQuickTime();
        this.checkPath();
    }

    protected void checkAssociations() {
        try {
            String string = Registry.getStringValue(Registry.REGISTRY_ROOT_KEY.CLASSES_ROOT, "Processing.Document\\shell\\open\\command", "");
            if (string == null) {
                if (Preferences.getBoolean("platform.auto_file_type_associations")) {
                    this.setAssociations();
                }
            } else if (!string.equals(openCommand) && Preferences.getBoolean("platform.auto_file_type_associations")) {
                this.setAssociations();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void setAssociations() throws UnsupportedEncodingException {
        if (!(Registry.createKey(Registry.REGISTRY_ROOT_KEY.CLASSES_ROOT, "", ".pde") && Registry.setStringValue(Registry.REGISTRY_ROOT_KEY.CLASSES_ROOT, ".pde", "", DOC) && Registry.createKey(Registry.REGISTRY_ROOT_KEY.CLASSES_ROOT, "", DOC) && Registry.setStringValue(Registry.REGISTRY_ROOT_KEY.CLASSES_ROOT, DOC, "", "Processing Source Code") && Registry.createKey(Registry.REGISTRY_ROOT_KEY.CLASSES_ROOT, DOC, "shell") && Registry.createKey(Registry.REGISTRY_ROOT_KEY.CLASSES_ROOT, "Processing.Document\\shell", "open") && Registry.createKey(Registry.REGISTRY_ROOT_KEY.CLASSES_ROOT, "Processing.Document\\shell\\open", "command") && Registry.setStringValue(Registry.REGISTRY_ROOT_KEY.CLASSES_ROOT, "Processing.Document\\shell\\open\\command", "", openCommand))) {
            Preferences.setBoolean("platform.auto_file_type_associations", false);
        }
    }

    protected void checkQuickTime() {
        try {
            File file;
            String string = Registry.getStringValue(Registry.REGISTRY_ROOT_KEY.LOCAL_MACHINE, "Software\\Apple Computer, Inc.\\QuickTime", "QTSysDir");
            if (string != null && (file = new File(string, "QTJava.zip")).exists()) {
                String string2 = file.getAbsolutePath();
                String string3 = System.getProperty("java.class.path");
                System.setProperty("java.class.path", string3 + File.pathSeparator + string2);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
    }

    protected void checkPath() {
        String string = System.getProperty("java.library.path");
        String[] stringArray = PApplet.split((String)string, (char)File.pathSeparatorChar);
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        for (String string2 : stringArray) {
            File file;
            if (string2.startsWith("\"")) {
                string2 = string2.substring(1);
            }
            if (string2.endsWith("\"")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            if (string2.endsWith(File.separator)) {
                string2 = string2.substring(0, string2.length() - File.separator.length());
            }
            if (!(file = new File(string2)).exists() || string2.trim().length() == 0) continue;
            stringArray2[n++] = string2;
        }
        String string3 = PApplet.join((String[])(stringArray2 = PApplet.subset((String[])stringArray2, (int)0, (int)n)), (String)File.pathSeparator);
        if (!string3.equals(string)) {
            System.setProperty("java.library.path", string3);
        }
    }

    public File getSettingsFolder() throws Exception {
        String string = "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders";
        String string2 = Registry.getStringValue(Registry.REGISTRY_ROOT_KEY.CURRENT_USER, string, "AppData");
        File file = new File(string2, "Arduino");
        return file;
    }

    public File getDefaultSketchbookFolder() throws Exception {
        String string = "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders";
        String string2 = Registry.getStringValue(Registry.REGISTRY_ROOT_KEY.CURRENT_USER, string, "Personal");
        return new File(string2, "Arduino");
    }

    public void openURL(String string) throws Exception {
        if (string.startsWith("http://")) {
            Runtime.getRuntime().exec("cmd /c start " + string);
        } else {
            Runtime.getRuntime().exec("cmd /c \"" + string + "\"");
        }
    }

    public boolean openFolderAvailable() {
        return true;
    }

    public void openFolder(File file) throws Exception {
        String string = file.getAbsolutePath();
        Runtime.getRuntime().exec("explorer \"" + string + "\"");
    }
}

