/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.CodeSigner;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.jar.JarEntry;
import java.util.jar.Manifest;
import sun.security.pkcs.ParsingException;
import sun.security.util.Debug;
import sun.security.util.ManifestDigester;
import sun.security.util.ManifestEntryVerifier;
import sun.security.util.SignatureFileVerifier;

class JarVerifier {
    static final Debug debug = Debug.getInstance("jar");
    private Hashtable verifiedSigners;
    private Hashtable sigFileSigners;
    private Hashtable sigFileData;
    private ArrayList pendingBlocks;
    private ArrayList signerCache;
    private boolean parsingBlockOrSF = false;
    private boolean parsingMeta = true;
    private boolean anyToVerify = true;
    private ByteArrayOutputStream baos;
    private ManifestDigester manDig;
    byte[] manifestRawBytes = null;

    public JarVerifier(byte[] byArray) {
        this.manifestRawBytes = byArray;
        this.sigFileSigners = new Hashtable();
        this.verifiedSigners = new Hashtable();
        this.sigFileData = new Hashtable(11);
        this.pendingBlocks = new ArrayList();
        this.baos = new ByteArrayOutputStream();
    }

    public void beginEntry(JarEntry jarEntry, ManifestEntryVerifier manifestEntryVerifier) throws IOException {
        String string;
        if (jarEntry == null) {
            return;
        }
        if (debug != null) {
            debug.println("beginEntry " + jarEntry.getName());
        }
        String string2 = jarEntry.getName();
        if (this.parsingMeta && ((string = string2.toUpperCase(Locale.ENGLISH)).startsWith("META-INF/") || string.startsWith("/META-INF/"))) {
            if (jarEntry.isDirectory()) {
                manifestEntryVerifier.setEntry(null, jarEntry);
                return;
            }
            if (SignatureFileVerifier.isBlockOrSF(string)) {
                this.parsingBlockOrSF = true;
                this.baos.reset();
                manifestEntryVerifier.setEntry(null, jarEntry);
            }
            return;
        }
        if (this.parsingMeta) {
            this.doneWithMeta();
        }
        if (jarEntry.isDirectory()) {
            manifestEntryVerifier.setEntry(null, jarEntry);
            return;
        }
        if (string2.startsWith("./")) {
            string2 = string2.substring(2);
        }
        if (string2.startsWith("/")) {
            string2 = string2.substring(1);
        }
        if (this.sigFileSigners.get(string2) != null) {
            manifestEntryVerifier.setEntry(string2, jarEntry);
            return;
        }
        manifestEntryVerifier.setEntry(null, jarEntry);
    }

    public void update(int n, ManifestEntryVerifier manifestEntryVerifier) throws IOException {
        if (n != -1) {
            if (this.parsingBlockOrSF) {
                this.baos.write(n);
            } else {
                manifestEntryVerifier.update((byte)n);
            }
        } else {
            this.processEntry(manifestEntryVerifier);
        }
    }

    public void update(int n, byte[] byArray, int n2, int n3, ManifestEntryVerifier manifestEntryVerifier) throws IOException {
        if (n != -1) {
            if (this.parsingBlockOrSF) {
                this.baos.write(byArray, n2, n);
            } else {
                manifestEntryVerifier.update(byArray, n2, n);
            }
        } else {
            this.processEntry(manifestEntryVerifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void processEntry(ManifestEntryVerifier manifestEntryVerifier) throws IOException {
        if (!this.parsingBlockOrSF) {
            JarEntry jarEntry = manifestEntryVerifier.getEntry();
            if (jarEntry == null) return;
            if (jarEntry.signers != null) return;
            jarEntry.signers = manifestEntryVerifier.verify(this.verifiedSigners, this.sigFileSigners);
            jarEntry.certs = JarVerifier.mapSignersToCertArray(jarEntry.signers);
            return;
        }
        try {
            Object object;
            String string;
            this.parsingBlockOrSF = false;
            if (debug != null) {
                debug.println("processEntry: processing block");
            }
            if ((string = manifestEntryVerifier.getEntry().getName().toUpperCase(Locale.ENGLISH)).endsWith(".SF")) {
                String string2 = string.substring(0, string.length() - 3);
                byte[] byArray = this.baos.toByteArray();
                this.sigFileData.put(string2, byArray);
                Iterator iterator = this.pendingBlocks.iterator();
                while (iterator.hasNext()) {
                    SignatureFileVerifier signatureFileVerifier = (SignatureFileVerifier)iterator.next();
                    if (!signatureFileVerifier.needSignatureFile(string2)) continue;
                    if (debug != null) {
                        debug.println("processEntry: processing pending block");
                    }
                    signatureFileVerifier.setSignatureFile(byArray);
                    signatureFileVerifier.process(this.sigFileSigners);
                }
                return;
            }
            String string3 = string.substring(0, string.lastIndexOf("."));
            if (this.signerCache == null) {
                this.signerCache = new ArrayList();
            }
            if (this.manDig == null) {
                object = this.manifestRawBytes;
                // MONITORENTER : this.manifestRawBytes
                if (this.manDig == null) {
                    this.manDig = new ManifestDigester(this.manifestRawBytes);
                    this.manifestRawBytes = null;
                }
                // MONITOREXIT : object
            }
            if (((SignatureFileVerifier)(object = (Object)new SignatureFileVerifier(this.signerCache, this.manDig, string, this.baos.toByteArray()))).needSignatureFileBytes()) {
                byte[] byArray = (byte[])this.sigFileData.get(string3);
                if (byArray == null) {
                    if (debug != null) {
                        debug.println("adding pending block");
                    }
                    this.pendingBlocks.add(object);
                    return;
                }
                ((SignatureFileVerifier)object).setSignatureFile(byArray);
            }
            ((SignatureFileVerifier)object).process(this.sigFileSigners);
            return;
        }
        catch (ParsingException parsingException) {
            if (debug == null) return;
            debug.println("processEntry caught: " + parsingException);
            return;
        }
        catch (IOException iOException) {
            if (debug == null) return;
            debug.println("processEntry caught: " + iOException);
            return;
        }
        catch (SignatureException signatureException) {
            if (debug == null) return;
            debug.println("processEntry caught: " + signatureException);
            return;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (debug == null) return;
            debug.println("processEntry caught: " + noSuchAlgorithmException);
            return;
        }
        catch (CertificateException certificateException) {
            if (debug == null) return;
            debug.println("processEntry caught: " + certificateException);
        }
    }

    public Certificate[] getCerts(String string) {
        return JarVerifier.mapSignersToCertArray(this.getCodeSigners(string));
    }

    public CodeSigner[] getCodeSigners(String string) {
        return (CodeSigner[])this.verifiedSigners.get(string);
    }

    private static Certificate[] mapSignersToCertArray(CodeSigner[] codeSignerArray) {
        if (codeSignerArray != null) {
            ArrayList<? extends Certificate> arrayList = new ArrayList<Certificate>();
            for (int i = 0; i < codeSignerArray.length; ++i) {
                arrayList.addAll(codeSignerArray[i].getSignerCertPath().getCertificates());
            }
            return arrayList.toArray(new Certificate[arrayList.size()]);
        }
        return null;
    }

    boolean nothingToVerify() {
        return !this.anyToVerify;
    }

    void doneWithMeta() {
        this.parsingMeta = false;
        this.anyToVerify = !this.sigFileSigners.isEmpty();
        this.baos = null;
        this.sigFileData = null;
        this.pendingBlocks = null;
        this.signerCache = null;
        this.manDig = null;
    }

    static class VerifierStream
    extends InputStream {
        private InputStream is;
        private JarVerifier jv;
        private ManifestEntryVerifier mev;
        private long numLeft;

        VerifierStream(Manifest manifest, JarEntry jarEntry, InputStream inputStream, JarVerifier jarVerifier) throws IOException {
            this.is = inputStream;
            this.jv = jarVerifier;
            this.mev = new ManifestEntryVerifier(manifest);
            this.jv.beginEntry(jarEntry, this.mev);
            this.numLeft = jarEntry.getSize();
            if (this.numLeft == 0L) {
                this.jv.update(-1, this.mev);
            }
        }

        public int read() throws IOException {
            if (this.numLeft > 0L) {
                int n = this.is.read();
                this.jv.update(n, this.mev);
                --this.numLeft;
                if (this.numLeft == 0L) {
                    this.jv.update(-1, this.mev);
                }
                return n;
            }
            return -1;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.numLeft > 0L && this.numLeft < (long)n2) {
                n2 = (int)this.numLeft;
            }
            if (this.numLeft > 0L) {
                int n3 = this.is.read(byArray, n, n2);
                this.jv.update(n3, byArray, n, n2, this.mev);
                this.numLeft -= (long)n3;
                if (this.numLeft == 0L) {
                    this.jv.update(-1, byArray, n, n2, this.mev);
                }
                return n3;
            }
            return -1;
        }

        public void close() throws IOException {
            if (this.is != null) {
                this.is.close();
            }
            this.is = null;
            this.mev = null;
            this.jv = null;
        }

        public int available() throws IOException {
            return this.is.available();
        }
    }
}

