/*
 * Decompiled with CFR 0.152.
 */
package processing.pdf;

import com.lowagie.text.Document;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.DefaultFontMapper;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import processing.core.PApplet;
import processing.core.PGraphicsJava2D;
import processing.core.PImage;
import processing.core.PStyle;

public class PGraphicsPDF
extends PGraphicsJava2D {
    protected File file;
    protected Document document;
    protected PdfWriter writer;
    protected PdfContentByte content;
    protected DefaultFontMapper mapper;

    public void setPath(String string) {
        this.path = string;
        if (string != null) {
            this.file = new File(string);
            if (!this.file.isAbsolute()) {
                this.file = null;
            }
        }
        if (this.file == null) {
            throw new RuntimeException("PGraphicsPDF requires an absolute path for the location of the output file.");
        }
    }

    protected void allocate() {
    }

    public void beginDraw() {
        if (this.document == null) {
            Object object;
            this.document = new Document(new Rectangle((float)this.width, (float)this.height));
            try {
                object = new FileOutputStream(this.file);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream((OutputStream)object, 16384);
                this.writer = PdfWriter.getInstance((Document)this.document, (OutputStream)bufferedOutputStream);
                this.document.open();
                this.content = this.writer.getDirectContent();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new RuntimeException("Problem saving the PDF file.");
            }
            this.mapper = new DefaultFontMapper();
            if (PApplet.platform == 2) {
                try {
                    object = System.getProperty("user.home") + "/Library/Fonts";
                    this.mapper.insertDirectory((String)object);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.mapper.insertDirectory("/System/Library/Fonts");
                this.mapper.insertDirectory("/Library/Fonts");
            } else if (PApplet.platform == 1) {
                object = File.listRoots();
                for (int i = 0; i < ((File[])object).length; ++i) {
                    if (object[i].toString().startsWith("A:")) continue;
                    File file = new File(object[i], "WINDOWS/Fonts");
                    if (file.exists()) {
                        this.mapper.insertDirectory(file.getAbsolutePath());
                        break;
                    }
                    file = new File(object[i], "WINNT/Fonts");
                    if (!file.exists()) continue;
                    this.mapper.insertDirectory(file.getAbsolutePath());
                    break;
                }
            }
            this.g2 = this.content.createGraphics((float)this.width, (float)this.height, (FontMapper)this.mapper);
        }
        super.beginDraw();
    }

    public void endDraw() {
    }

    protected static boolean fileExists(File file) {
        try {
            Process process = Runtime.getRuntime().exec(new String[]{"cmd.exe", "/c", "dir", file.getAbsolutePath()});
            boolean bl = false;
            int n = -1;
            InputStream inputStream = process.getInputStream();
            InputStream inputStream2 = process.getErrorStream();
            while (!bl) {
                while (inputStream.read() >= 0) {
                }
                while (inputStream2.read() >= 0) {
                }
                try {
                    n = process.exitValue();
                    bl = true;
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    Thread.sleep(100L);
                }
            }
            return n == 0;
        }
        catch (IOException iOException) {
            System.out.println("Unable to check for file: " + file + " : " + iOException);
            return false;
        }
        catch (InterruptedException interruptedException) {
            System.out.println("Unable to check for file.  Interrupted: " + file + " : " + interruptedException);
            return false;
        }
    }

    public void textMode(int n) {
        if (this.textMode != n) {
            if (n == 5) {
                this.g2.dispose();
                this.g2 = this.content.createGraphicsShapes((float)this.width, (float)this.height);
            } else if (n == 4) {
                this.g2.dispose();
                this.g2 = this.content.createGraphics((float)this.width, (float)this.height, (FontMapper)this.mapper);
            } else {
                if (n == 256) {
                    throw new RuntimeException("textMode(SCREEN) not supported with PDF");
                }
                throw new RuntimeException("That textMode() does not exist");
            }
        }
    }

    public void nextPage() {
        PStyle pStyle = this.getStyle();
        this.g2.dispose();
        try {
            this.document.newPage();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.textMode == 5) {
            this.g2 = this.content.createGraphicsShapes((float)this.width, (float)this.height);
        } else if (this.textMode == 4) {
            this.g2 = this.content.createGraphics((float)this.width, (float)this.height, (FontMapper)this.mapper);
        }
        this.style(pStyle);
    }

    public void dispose() {
        if (this.document != null) {
            this.g2.dispose();
            this.document.close();
            this.document = null;
        }
    }

    public boolean displayable() {
        return false;
    }

    public void loadPixels() {
        this.nope("loadPixels");
    }

    public void updatePixels() {
        this.nope("updatePixels");
    }

    public void updatePixels(int n, int n2, int n3, int n4) {
        this.nope("updatePixels");
    }

    public int get(int n, int n2) {
        this.nope("get");
        return 0;
    }

    public PImage get(int n, int n2, int n3, int n4) {
        this.nope("get");
        return null;
    }

    public PImage get() {
        this.nope("get");
        return null;
    }

    public void set(int n, int n2, int n3) {
        this.nope("set");
    }

    public void set(int n, int n2, PImage pImage) {
        this.nope("set");
    }

    public void mask(int[] nArray) {
        this.nope("mask");
    }

    public void mask(PImage pImage) {
        this.nope("mask");
    }

    public void filter(int n) {
        this.nope("filter");
    }

    public void filter(int n, float f) {
        this.nope("filter");
    }

    public void copy(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.nope("copy");
    }

    public void copy(PImage pImage, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.nope("copy");
    }

    public void blend(int n, int n2, int n3, int n4, int n5) {
        this.nope("blend");
    }

    public void blend(PImage pImage, int n, int n2, int n3, int n4, int n5) {
        this.nope("blend");
    }

    public void blend(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.nope("blend");
    }

    public void blend(PImage pImage, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.nope("blend");
    }

    public void save(String string) {
        this.nope("save");
    }

    public void addFonts(String string) {
        this.mapper.insertDirectory(string);
    }

    public String[] listFonts() {
        HashMap hashMap = this.mapper.getAliases();
        Set set = hashMap.entrySet();
        String[] stringArray = new String[set.size()];
        Iterator iterator = set.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            stringArray[n++] = (String)entry.getKey();
        }
        return PApplet.sort((String[])stringArray);
    }

    protected void nope(String string) {
        throw new RuntimeException("No " + string + "() for PGraphicsPDF");
    }
}

