/*
 * Decompiled with CFR 0.152.
 */
package processing.app.debug;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.jdt.core.compiler.CompilationProgress;
import org.eclipse.jdt.core.compiler.batch.BatchCompiler;
import processing.app.Base;
import processing.app.Sketch;
import processing.app.SketchCode;
import processing.app.debug.RunnerException;
import processing.core.PApplet;

public class Compiler {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean compile(Sketch sketch, String string, String string2) throws RunnerException {
        String string3;
        RunnerException runnerException = null;
        boolean bl = false;
        String[] stringArray = new String[]{"-Xemacs", "-source", "1.5", "-target", "1.5", "-classpath", sketch.getClassPath(), "-nowarn", "-d", string};
        String[] stringArray2 = new String[sketch.getCodeCount()];
        int n = 0;
        stringArray2[n++] = new File(string, string2 + ".java").getAbsolutePath();
        for (SketchCode sketchCode : sketch.getCode()) {
            if (!sketchCode.isExtension("java")) continue;
            string3 = new File(string, sketchCode.getFileName()).getAbsolutePath();
            stringArray2[n++] = string3;
        }
        Object[] objectArray = new String[stringArray.length + n];
        System.arraycopy(stringArray, 0, objectArray, 0, stringArray.length);
        System.arraycopy(stringArray2, 0, objectArray, stringArray.length, n);
        try {
            final StringBuffer stringBuffer = new StringBuffer();
            Writer writer = new Writer(){

                public void write(char[] cArray, int n, int n2) {
                    stringBuffer.append(cArray, n, n2);
                }

                public void flush() {
                }

                public void close() {
                }
            };
            PrintWriter printWriter = new PrintWriter(writer);
            string3 = null;
            PrintWriter printWriter2 = new PrintWriter(System.out);
            bl = BatchCompiler.compile((String[])objectArray, (PrintWriter)printWriter2, (PrintWriter)printWriter, (CompilationProgress)string3);
            printWriter.flush();
            printWriter.close();
            BufferedReader bufferedReader = new BufferedReader(new StringReader(stringBuffer.toString()));
            String string4 = null;
            while ((string4 = bufferedReader.readLine()) != null) {
                Object object;
                int n2;
                String string5 = "([\\w\\d_]+.java):(\\d+):\\s*(.*):\\s*(.*)\\s*";
                String[] stringArray3 = PApplet.match((String)string4, (String)string5);
                if (stringArray3 == null) {
                    runnerException = new RunnerException("Cannot parse error text: " + string4);
                    runnerException.hideStackTrace();
                    System.err.println(string4);
                    while ((string4 = bufferedReader.readLine()) != null) {
                        System.err.println(string4);
                    }
                    break;
                }
                String string6 = stringArray3[1];
                int n3 = PApplet.parseInt((String)stringArray3[2]) - 1;
                String string7 = stringArray3[4];
                int n4 = 0;
                int n5 = -1;
                for (n2 = 0; n2 < sketch.getCodeCount(); ++n2) {
                    object = sketch.getCode(n2);
                    if (!((SketchCode)object).isExtension("java") || !string6.equals(((SketchCode)object).getFileName())) continue;
                    n4 = n2;
                    n5 = n3;
                }
                if (n4 == 0) {
                    for (n2 = 0; n2 < sketch.getCodeCount(); ++n2) {
                        object = sketch.getCode(n2);
                        if (!((SketchCode)object).isExtension("pde") || ((SketchCode)object).getPreprocOffset() > n3) continue;
                        n4 = n2;
                        n5 = n3 - ((SketchCode)object).getPreprocOffset();
                    }
                }
                runnerException = new RunnerException(string7, n4, n5, -1, false);
                if (string7.startsWith("The import ") && string7.endsWith("cannot be resolved")) {
                    String string8 = string7.substring("The import ".length());
                    string8 = string8.substring(0, string8.indexOf(32));
                    System.err.println("Note that release 1.0, libraries must be installed in a folder named 'libraries' inside the 'sketchbook' folder.");
                    runnerException.setMessage("The package \u201c" + string8 + "\u201d" + " does not exist. " + "You might be missing a library.");
                    object = Base.getSketchbookLibrariesFolder();
                    if (!((File)object).exists() && ((File)object).mkdirs()) {
                        Base.openFolder((File)object);
                    }
                } else if (string7.endsWith("cannot be resolved to a type")) {
                    String string9 = string7.substring(0, string7.indexOf(32));
                    if (string9.equals("BFont") || string9.equals("BGraphics") || string9.equals("BImage")) {
                        this.handleCrustyCode(runnerException);
                    } else {
                        runnerException.setMessage("Cannot find a class or type named \u201c" + string9 + "\u201d");
                    }
                } else if (string7.endsWith("cannot be resolved")) {
                    String string10 = string7.substring(0, string7.indexOf(32));
                    if (string10.equals("LINE_LOOP") || string10.equals("LINE_STRIP") || string10.equals("framerate")) {
                        this.handleCrustyCode(runnerException);
                    } else {
                        runnerException.setMessage("Cannot find anything named \u201c" + string10 + "\u201d");
                    }
                } else if (!string7.startsWith("Duplicate")) {
                    String[] stringArray4 = null;
                    object = "The method (\\S+\\(.*\\)) is undefined for the type (.*)";
                    stringArray4 = PApplet.match((String)string7, (String)object);
                    if (stringArray4 != null) {
                        if (stringArray4[1].equals("framerate(int)") || stringArray4[1].equals("push()")) {
                            this.handleCrustyCode(runnerException);
                        } else {
                            String string11 = "The function " + stringArray4[1] + " does not exist.";
                            runnerException.setMessage(string11);
                        }
                        break;
                    }
                }
                if (runnerException == null) continue;
                runnerException.hideStackTrace();
                break;
            }
        }
        catch (IOException iOException) {
            String string12 = "Error while compiling. (" + iOException.getMessage() + ")";
            runnerException = new RunnerException(string12);
            iOException.printStackTrace();
            bl = false;
        }
        if (runnerException != null) {
            throw runnerException;
        }
        return bl;
    }

    void handleCrustyCode(RunnerException runnerException) {
        runnerException.setMessage("This code needs to be updated, please read the \u201cchanges\u201d reference.");
        Base.showReference("changes.html");
    }

    protected int caretColumn(String string) {
        return string.indexOf("^");
    }

    public static String contentsToClassPath(File file) {
        if (file == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("path.separator");
        try {
            String string2 = file.getCanonicalPath();
            if (!string2.endsWith(File.separator)) {
                string2 = string2 + File.separator;
            }
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].startsWith(".") || !stringArray[i].toLowerCase().endsWith(".jar") && !stringArray[i].toLowerCase().endsWith(".zip")) continue;
                stringBuffer.append(string);
                stringBuffer.append(string2);
                stringBuffer.append(stringArray[i]);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return stringBuffer.toString();
    }

    public static String[] packageListFromClassPath(String string) {
        Object object;
        int n;
        Hashtable hashtable = new Hashtable();
        String[] stringArray = PApplet.split((String)string, (char)File.pathSeparatorChar);
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].length() == 0) continue;
            if (stringArray[n].toLowerCase().endsWith(".jar") || stringArray[n].toLowerCase().endsWith(".zip")) {
                Compiler.packageListFromZip(stringArray[n], hashtable);
                continue;
            }
            object = new File(stringArray[n]);
            if (!((File)object).exists() || !((File)object).isDirectory()) continue;
            Compiler.packageListFromFolder((File)object, null, hashtable);
        }
        n = hashtable.size();
        object = new String[n];
        int n2 = 0;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            object[n2++] = ((String)enumeration.nextElement()).replace('/', '.');
        }
        return object;
    }

    private static void packageListFromZip(String string, Hashtable hashtable) {
        try {
            ZipFile zipFile = new ZipFile(string);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                String string2;
                int n;
                String string3;
                ZipEntry zipEntry = enumeration.nextElement();
                if (zipEntry.isDirectory() || !(string3 = zipEntry.getName()).endsWith(".class") || (n = string3.lastIndexOf(47)) == -1 || hashtable.get(string2 = string3.substring(0, n)) != null) continue;
                hashtable.put(string2, new Object());
            }
        }
        catch (IOException iOException) {
            System.err.println("Ignoring " + string + " (" + iOException.getMessage() + ")");
        }
    }

    private static void packageListFromFolder(File file, String string, Hashtable hashtable) {
        boolean bl = false;
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals(".") || stringArray[i].equals("..")) continue;
            File file2 = new File(file, stringArray[i]);
            if (file2.isDirectory()) {
                String string2 = string == null ? stringArray[i] : string + "." + stringArray[i];
                Compiler.packageListFromFolder(file2, string2, hashtable);
                continue;
            }
            if (bl || !stringArray[i].endsWith(".class")) continue;
            hashtable.put(string, new Object());
            bl = true;
        }
    }
}

