/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import antlr.RecognitionException;
import antlr.TokenStreamRecognitionException;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import processing.app.Base;
import processing.app.Editor;
import processing.app.Preferences;
import processing.app.SketchCode;
import processing.app.debug.Compiler;
import processing.app.debug.RunnerException;
import processing.app.preproc.PdePreprocessor;
import processing.core.PApplet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sketch {
    private static File tempBuildFolder;
    private Editor editor;
    private File primaryFile;
    private String name;
    private boolean modified;
    private File folder;
    private File dataFolder;
    private File codeFolder;
    private SketchCode current;
    private int currentIndex;
    private int codeCount;
    private SketchCode[] code;
    private String appletClassName;
    private String classPath;
    private String libraryPath;
    private ArrayList<File> importedLibraries;
    boolean renamingCode;

    public Sketch(Editor editor, String string) throws IOException {
        this.editor = editor;
        this.primaryFile = new File(string);
        String string2 = this.primaryFile.getName();
        int n = this.getDefaultExtension().length() + 1;
        this.name = string2.substring(0, string2.length() - n);
        tempBuildFolder = Base.getBuildFolder();
        this.folder = new File(new File(string).getParent());
        this.load();
    }

    protected void load() {
        this.codeFolder = new File(this.folder, "code");
        this.dataFolder = new File(this.folder, "data");
        String[] stringArray = this.folder.list();
        this.codeCount = 0;
        this.code = new SketchCode[stringArray.length];
        String[] stringArray2 = this.getExtensions();
        for (String string : stringArray) {
            if (string.startsWith(".") || new File(this.folder, string).isDirectory()) continue;
            String string2 = string;
            for (String string3 : stringArray2) {
                if (!string2.toLowerCase().endsWith("." + string3) || !Sketch.isSanitaryName(string2 = string2.substring(0, string2.length() - (string3.length() + 1)))) continue;
                this.code[this.codeCount++] = new SketchCode(new File(this.folder, string), string3);
            }
        }
        this.code = (SketchCode[])PApplet.subset((Object)this.code, (int)0, (int)this.codeCount);
        for (int i = 1; i < this.codeCount; ++i) {
            if (!this.code[i].getFile().equals(this.primaryFile)) continue;
            SketchCode sketchCode = this.code[0];
            this.code[0] = this.code[i];
            this.code[i] = sketchCode;
            break;
        }
        this.sortCode();
        if (this.editor != null) {
            this.setCurrentCode(0);
        }
    }

    protected void replaceCode(SketchCode sketchCode) {
        for (int i = 0; i < this.codeCount; ++i) {
            if (!this.code[i].getFileName().equals(sketchCode.getFileName())) continue;
            this.code[i] = sketchCode;
            break;
        }
    }

    protected void insertCode(SketchCode sketchCode) {
        this.ensureExistence();
        this.code = (SketchCode[])PApplet.append((Object)this.code, (Object)sketchCode);
        ++this.codeCount;
    }

    protected void sortCode() {
        for (int i = 1; i < this.codeCount; ++i) {
            int n = i;
            for (int j = i + 1; j < this.codeCount; ++j) {
                if (this.code[j].getFileName().compareTo(this.code[n].getFileName()) >= 0) continue;
                n = j;
            }
            if (n == i) continue;
            SketchCode sketchCode = this.code[n];
            this.code[n] = this.code[i];
            this.code[i] = sketchCode;
        }
    }

    public void handleNewCode() {
        this.ensureExistence();
        if (this.isReadOnly()) {
            Base.showMessage("Sketch is Read-Only", "Some files are marked \"read-only\", so you'll\nneed to re-save the sketch in another location,\nand try again.");
            return;
        }
        this.renamingCode = false;
        this.editor.status.edit("Name for new file:", "");
    }

    public void handleRenameCode() {
        this.ensureExistence();
        if (this.currentIndex == 0 && this.editor.untitled) {
            Base.showMessage("Sketch is Untitled", "How about saving the sketch first \nbefore trying to rename it?");
            return;
        }
        if (this.isReadOnly()) {
            Base.showMessage("Sketch is Read-Only", "Some files are marked \"read-only\", so you'll\nneed to re-save the sketch in another location,\nand try again.");
            return;
        }
        this.renamingCode = true;
        String string = this.currentIndex == 0 ? "New name for sketch:" : "New name for file:";
        String string2 = this.current.isExtension("pde") ? this.current.getPrettyName() : this.current.getFileName();
        this.editor.status.edit(string, string2);
    }

    protected void nameCode(String string) {
        String string2;
        this.ensureExistence();
        if (string.indexOf(46) == -1) {
            string = string + "." + this.getDefaultExtension();
        }
        if (this.renamingCode && string.equalsIgnoreCase(this.current.getFileName())) {
            return;
        }
        if ((string = string.trim()).equals("")) {
            return;
        }
        int n = string.indexOf(46);
        if (n == 0) {
            Base.showWarning("Problem with rename", "The name cannot start with a period.", null);
            return;
        }
        String string3 = string.substring(n + 1).toLowerCase();
        if (!this.validExtension(string3)) {
            Base.showWarning("Problem with rename", "\"." + string3 + "\"" + "is not a valid extension.", null);
            return;
        }
        if (!this.isDefaultExtension(string3) && this.renamingCode && this.current == this.code[0]) {
            Base.showWarning("Problem with rename", "The main .pde file cannot be .java file.\n(It may be time for your to graduate to a\n\"real\" programming environment)", null);
            return;
        }
        String string4 = string.substring(0, n);
        if (!string4.equals(string2 = Sketch.sanitizeName(string4))) {
            string = string2 + "." + string3;
        }
        for (SketchCode sketchCode : this.code) {
            if (!string2.equalsIgnoreCase(sketchCode.getPrettyName())) continue;
            Base.showMessage("Nope", "A file named \"" + sketchCode.getFileName() + "\" already exists\n" + "in \"" + this.folder.getAbsolutePath() + "\"");
            return;
        }
        File file = new File(this.folder, string);
        if (this.renamingCode) {
            if (this.currentIndex == 0) {
                int n2;
                String string5 = string.substring(0, string.indexOf(46));
                File file2 = new File(this.folder.getParentFile(), string5);
                if (file2.exists()) {
                    Base.showWarning("Cannot Rename", "Sorry, a sketch (or folder) named \"" + string + "\" already exists.", null);
                    return;
                }
                if (this.current.isModified()) {
                    this.current.setProgram(this.editor.getText());
                    try {
                        this.current.save();
                    }
                    catch (Exception exception) {
                        Base.showWarning("Error", "Could not rename the sketch. (0)", exception);
                        return;
                    }
                }
                if (!this.current.renameTo(file, string3)) {
                    Base.showWarning("Error", "Could not rename \"" + this.current.getFileName() + "\" to \"" + file.getName() + "\"", null);
                    return;
                }
                try {
                    for (n2 = 1; n2 < this.codeCount; ++n2) {
                        this.code[n2].save();
                    }
                }
                catch (Exception exception) {
                    Base.showWarning("Error", "Could not rename the sketch. (1)", exception);
                    return;
                }
                n2 = this.folder.renameTo(file2) ? 1 : 0;
                if (n2 == 0) {
                    Base.showWarning("Error", "Could not rename the sketch. (2)", null);
                    return;
                }
                File file3 = new File(file2, string + ".pde");
                String string6 = file3.getAbsolutePath();
                this.editor.handleOpenUnchecked(string6, this.currentIndex, this.editor.getSelectionStart(), this.editor.getSelectionStop(), this.editor.getScrollPosition());
                this.editor.base.rebuildSketchbookMenus();
            } else if (!this.current.renameTo(file, string3)) {
                Base.showWarning("Error", "Could not rename \"" + this.current.getFileName() + "\" to \"" + file.getName() + "\"", null);
                return;
            }
        } else {
            try {
                if (!file.createNewFile()) {
                    throw new IOException("createNewFile() returned false");
                }
            }
            catch (IOException iOException) {
                Base.showWarning("Error", "Could not create the file \"" + file + "\"\n" + "in \"" + this.folder.getAbsolutePath() + "\"", iOException);
                return;
            }
            SketchCode sketchCode = new SketchCode(file, string3);
            this.insertCode(sketchCode);
        }
        this.sortCode();
        this.setCurrentCode(string);
        this.editor.header.rebuild();
    }

    public void handleDeleteCode() {
        Object[] objectArray;
        this.ensureExistence();
        if (this.isReadOnly()) {
            Base.showMessage("Sketch is Read-Only", "Some files are marked \"read-only\", so you'll\nneed to re-save the sketch in another location,\nand try again.");
            return;
        }
        String string = this.currentIndex == 0 ? "Are you sure you want to delete this sketch?" : "Are you sure you want to delete \"" + this.current.getPrettyName() + "\"?";
        int n = JOptionPane.showOptionDialog(this.editor, string, "Delete", 0, 3, null, objectArray = new Object[]{"OK", "Cancel"}, objectArray[0]);
        if (n == 0) {
            if (this.currentIndex == 0) {
                Base.removeDir(this.folder);
                this.editor.base.handleClose(this.editor);
            } else {
                if (!this.current.deleteFile()) {
                    Base.showMessage("Couldn't do it", "Could not delete \"" + this.current.getFileName() + "\".");
                    return;
                }
                this.removeCode(this.current);
                this.setCurrentCode(0);
                this.editor.header.repaint();
            }
        }
    }

    protected void removeCode(SketchCode sketchCode) {
        for (int i = 0; i < this.codeCount; ++i) {
            if (this.code[i] != sketchCode) continue;
            for (int j = i; j < this.codeCount - 1; ++j) {
                this.code[j] = this.code[j + 1];
            }
            --this.codeCount;
            this.code = (SketchCode[])PApplet.shorten((Object)this.code);
            return;
        }
        System.err.println("removeCode: internal error.. could not find code");
    }

    public void handlePrevCode() {
        int n = this.currentIndex - 1;
        if (n < 0) {
            n = this.codeCount - 1;
        }
        this.setCurrentCode(n);
    }

    public void handleNextCode() {
        this.setCurrentCode((this.currentIndex + 1) % this.codeCount);
    }

    public void setModified(boolean bl) {
        this.current.setModified(bl);
        this.calcModified();
    }

    protected void calcModified() {
        this.modified = false;
        for (int i = 0; i < this.codeCount; ++i) {
            if (!this.code[i].isModified()) continue;
            this.modified = true;
            break;
        }
        this.editor.header.repaint();
        if (Base.isMacOS()) {
            Boolean bl = this.modified ? Boolean.TRUE : Boolean.FALSE;
            this.editor.getRootPane().putClientProperty("windowModified", bl);
        }
    }

    public boolean isModified() {
        return this.modified;
    }

    public boolean save() throws IOException {
        this.ensureExistence();
        if (this.current.isModified()) {
            this.current.setProgram(this.editor.getText());
        }
        if (this.isReadOnly()) {
            Base.showMessage("Sketch is read-only", "Some files are marked \"read-only\", so you'll\nneed to re-save this sketch to another location.");
            if (!this.saveAs()) {
                return false;
            }
        }
        for (int i = 0; i < this.codeCount; ++i) {
            if (!this.code[i].isModified()) continue;
            this.code[i].save();
        }
        this.calcModified();
        return true;
    }

    protected boolean saveAs() throws IOException {
        File file;
        Object object;
        String string = null;
        String string2 = null;
        FileDialog fileDialog = new FileDialog((Frame)this.editor, "Save sketch folder as...", 1);
        if (this.isReadOnly() || this.isUntitled()) {
            fileDialog.setDirectory(Preferences.get("sketchbook.path"));
        } else {
            fileDialog.setDirectory(this.folder.getParent());
        }
        String string3 = this.folder.getName();
        fileDialog.setFile(string3);
        fileDialog.setVisible(true);
        string = fileDialog.getDirectory();
        string2 = fileDialog.getFile();
        if (string2 == null) {
            return false;
        }
        string2 = Sketch.checkName(string2);
        File file2 = new File(string, string2);
        for (int i = 1; i < this.codeCount; ++i) {
            if (!string2.equalsIgnoreCase(this.code[i].getPrettyName())) continue;
            Base.showMessage("Nope", "You can't save the sketch as \"" + string2 + "\"\n" + "because the sketch already has a tab with that name.");
            return false;
        }
        if (file2.equals(this.folder)) {
            return this.save();
        }
        try {
            String string4 = file2.getCanonicalPath() + File.separator;
            object = this.folder.getCanonicalPath() + File.separator;
            if (string4.indexOf((String)object) == 0) {
                Base.showWarning("How very Borges of you", "You cannot save the sketch into a folder\ninside itself. This would go on forever.", null);
                return false;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (file2.exists()) {
            Base.removeDir(file2);
        }
        file2.mkdirs();
        if (this.current.isModified()) {
            this.current.setProgram(this.editor.getText());
        }
        for (int i = 1; i < this.codeCount; ++i) {
            object = new File(file2, this.code[i].getFileName());
            this.code[i].saveAs((File)object);
        }
        if (this.dataFolder.exists()) {
            File file3 = new File(file2, "data");
            Base.copyDir(this.dataFolder, file3);
        }
        if (this.codeFolder.exists()) {
            File file4 = new File(file2, "code");
            Base.copyDir(this.codeFolder, file4);
        }
        if ((file = new File(this.folder, "applet.html")).exists()) {
            object = new File(file2, "applet.html");
            Base.copyFile(file, (File)object);
        }
        object = new File(file2, string2 + ".pde");
        this.code[0].saveAs((File)object);
        this.editor.handleOpenUnchecked(((File)object).getPath(), this.currentIndex, this.editor.getSelectionStart(), this.editor.getSelectionStop(), this.editor.getScrollPosition());
        this.editor.base.rebuildSketchbookMenus();
        this.setUntitled(false);
        return true;
    }

    public void handleAddFile() {
        this.ensureExistence();
        if (this.isReadOnly()) {
            Base.showMessage("Sketch is Read-Only", "Some files are marked \"read-only\", so you'll\nneed to re-save the sketch in another location,\nand try again.");
            return;
        }
        String string = "Select an image or other data file to copy to your sketch";
        FileDialog fileDialog = new FileDialog((Frame)this.editor, string, 0);
        fileDialog.setVisible(true);
        String string2 = fileDialog.getDirectory();
        String string3 = fileDialog.getFile();
        if (string3 == null) {
            return;
        }
        File file = new File(string2, string3);
        boolean bl = this.addFile(file);
        if (bl) {
            this.editor.statusNotice("One file added to the sketch.");
        }
    }

    public boolean addFile(File file) {
        boolean bl;
        String string = file.getName();
        File file2 = null;
        String string2 = null;
        boolean bl2 = false;
        if (string.toLowerCase().endsWith(".class") || string.toLowerCase().endsWith(".jar") || string.toLowerCase().endsWith(".dll") || string.toLowerCase().endsWith(".jnilib") || string.toLowerCase().endsWith(".so")) {
            this.prepareCodeFolder();
            file2 = new File(this.codeFolder, string);
        } else {
            for (String string3 : this.getExtensions()) {
                String string4 = string.toLowerCase();
                if (!string4.endsWith("." + (String)string3)) continue;
                file2 = new File(this.folder, string);
                string2 = string3;
            }
            if (string2 == null) {
                this.prepareDataFolder();
                file2 = new File(this.dataFolder, string);
            }
        }
        if (file2.exists()) {
            Object[] objectArray = new Object[]{"OK", "Cancel"};
            String string5 = "Replace the existing version of " + string + "?";
            int n = JOptionPane.showOptionDialog(this.editor, string5, "Replace", 0, 3, null, objectArray, objectArray[0]);
            if (n == 0) {
                bl2 = true;
            } else {
                return false;
            }
        }
        if (bl2 && !(bl = file2.delete())) {
            Base.showWarning("Error adding file", "Could not delete the existing '" + string + "' file.", null);
            return false;
        }
        if (string2 == null && file.equals(file2)) {
            Base.showWarning("You can't fool me", "This file has already been copied to the\nlocation from which where you're trying to add it.\nI ain't not doin nuthin'.", null);
            return false;
        }
        if (!file.equals(file2)) {
            try {
                Base.copyFile(file, file2);
            }
            catch (IOException iOException) {
                Base.showWarning("Error adding file", "Could not add '" + string + "' to the sketch.", iOException);
                return false;
            }
        }
        if (string2 != null) {
            SketchCode sketchCode = new SketchCode(file2, string2);
            if (bl2) {
                this.replaceCode(sketchCode);
            } else {
                this.insertCode(sketchCode);
                this.sortCode();
            }
            this.setCurrentCode(string);
            this.editor.header.repaint();
            if (this.editor.untitled) {
                this.current.setModified(true);
            }
        } else if (this.editor.untitled) {
            this.code[0].setModified(true);
        }
        return true;
    }

    public void importLibrary(String string) {
        this.ensureExistence();
        String[] stringArray = Compiler.packageListFromClassPath(string);
        if (this.hasDefaultExtension(this.current)) {
            this.setCurrentCode(0);
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append("import ");
            stringBuffer.append(stringArray[i]);
            stringBuffer.append(".*;\n");
        }
        stringBuffer.append('\n');
        stringBuffer.append(this.editor.getText());
        this.editor.setText(stringBuffer.toString());
        this.editor.setSelection(0, 0);
        this.setModified(true);
    }

    public void setCurrentCode(int n) {
        if (this.currentIndex == n && this.current != null) {
            return;
        }
        if (this.current != null) {
            this.current.setState(this.editor.getText(), this.editor.getSelectionStart(), this.editor.getSelectionStop(), this.editor.getScrollPosition());
        }
        this.current = this.code[n];
        this.currentIndex = n;
        this.editor.setCode(this.current);
        this.editor.header.rebuild();
    }

    protected void setCurrentCode(String string) {
        for (int i = 0; i < this.codeCount; ++i) {
            if (!string.equals(this.code[i].getFileName()) && !string.equals(this.code[i].getPrettyName())) continue;
            this.setCurrentCode(i);
            return;
        }
    }

    protected void cleanup() {
        System.gc();
        Base.removeDescendants(tempBuildFolder);
    }

    protected String compile() throws RunnerException {
        this.ensureExistence();
        this.current.setProgram(this.editor.getText());
        if (Preferences.getBoolean("editor.external")) {
            this.current = null;
            this.load();
        }
        this.cleanup();
        return this.build(tempBuildFolder.getAbsolutePath());
    }

    public String preprocess(String string) throws RunnerException {
        return this.preprocess(string, new PdePreprocessor());
    }

    public String preprocess(String string, PdePreprocessor pdePreprocessor) throws RunnerException {
        Object object;
        CharSequence charSequence;
        this.ensureExistence();
        String[] stringArray = null;
        this.classPath = string;
        if (this.codeFolder.exists()) {
            this.libraryPath = this.codeFolder.getAbsolutePath();
            charSequence = Compiler.contentsToClassPath(this.codeFolder);
            this.classPath = this.classPath + File.pathSeparator + (String)charSequence;
            stringArray = Compiler.packageListFromClassPath((String)charSequence);
        } else {
            this.libraryPath = "";
        }
        charSequence = new StringBuffer();
        int n = 0;
        for (SketchCode object2 : this.code) {
            if (!object2.isExtension("pde")) continue;
            object2.setPreprocOffset(n);
            ((StringBuffer)charSequence).append(object2.getProgram());
            ((StringBuffer)charSequence).append('\n');
            n += object2.getLineCount();
        }
        int n2 = 0;
        try {
            n2 = pdePreprocessor.writePrefix(((StringBuffer)charSequence).toString(), string, this.name, stringArray);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            String string2 = "Build folder disappeared or could not be written";
            throw new RunnerException(string2);
        }
        String string3 = null;
        try {
            object = pdePreprocessor.write();
            if (object == null) {
                throw new RunnerException("Could not find main class");
            }
            string3 = object;
        }
        catch (RecognitionException recognitionException) {
            int n3;
            boolean n32 = false;
            int n4 = recognitionException.getLine() - 1;
            for (int i = 1; i < this.codeCount; ++i) {
                if (!this.code[i].isExtension("pde") || this.code[i].getPreprocOffset() >= n4) continue;
                n3 = i;
            }
            n4 -= this.code[n3].getPreprocOffset();
            String string2 = recognitionException.getMessage();
            if (string2.equals("expecting RCURLY, found 'null'")) {
                throw new RunnerException("Found one too many { characters without a } to match it.", n3, n4, recognitionException.getColumn());
            }
            if (string2.indexOf("expecting RBRACK") != -1) {
                System.err.println(string2);
                throw new RunnerException("Syntax error, maybe a missing ] character?", n3, n4, recognitionException.getColumn());
            }
            if (string2.indexOf("expecting SEMI") != -1) {
                System.err.println(string2);
                throw new RunnerException("Syntax error, maybe a missing semicolon?", n3, n4, recognitionException.getColumn());
            }
            if (string2.indexOf("expecting RPAREN") != -1) {
                System.err.println(string2);
                throw new RunnerException("Syntax error, maybe a missing right parenthesis?", n3, n4, recognitionException.getColumn());
            }
            if (string2.indexOf("preproc.web_colors") != -1) {
                throw new RunnerException("A web color (such as #ffcc00) must be six digits.", n3, n4, recognitionException.getColumn(), false);
            }
            throw new RunnerException(string2, n3, n4, recognitionException.getColumn());
        }
        catch (TokenStreamRecognitionException tokenStreamRecognitionException) {
            String string4 = "^line (\\d+):(\\d+):\\s";
            String[] stringArray2 = PApplet.match((String)tokenStreamRecognitionException.toString(), (String)string4);
            if (stringArray2 != null) {
                int n5 = Integer.parseInt(stringArray2[1]) - 1;
                int n6 = Integer.parseInt(stringArray2[2]);
                int n7 = 0;
                for (int i = 1; i < this.codeCount; ++i) {
                    if (!this.code[i].isExtension("pde") || this.code[i].getPreprocOffset() >= n5) continue;
                    n7 = i;
                }
                throw new RunnerException(tokenStreamRecognitionException.getMessage(), n7, n5 -= this.code[n7].getPreprocOffset(), n6);
            }
            String string5 = tokenStreamRecognitionException.toString();
            throw new RunnerException(string5, 0, -1, -1);
        }
        catch (RunnerException runnerException) {
            throw runnerException;
        }
        catch (Exception exception) {
            System.err.println("Uncaught exception type:" + exception.getClass());
            exception.printStackTrace();
            throw new RunnerException(exception.toString());
        }
        this.importedLibraries = new ArrayList();
        for (String string6 : pdePreprocessor.getExtraImports()) {
            int n8 = string6.lastIndexOf(46);
            String string7 = n8 == -1 ? string6 : string6.substring(0, n8);
            File file = Base.importToLibraryTable.get(string7);
            if (file == null) continue;
            this.importedLibraries.add(file);
            this.classPath = this.classPath + Compiler.contentsToClassPath(file);
            this.libraryPath = this.libraryPath + File.pathSeparator + file.getAbsolutePath();
        }
        object = System.getProperty("java.class.path");
        if (((String)object).startsWith("\"") && ((String)object).endsWith("\"")) {
            object = ((String)object).substring(1, ((String)object).length() - 1);
        }
        this.classPath = this.classPath + File.pathSeparator + (String)object;
        for (SketchCode sketchCode : this.code) {
            if (sketchCode.isExtension("java")) {
                String string8 = sketchCode.getFileName();
                try {
                    Base.saveFile(sketchCode.getProgram(), new File(string, string8));
                    continue;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    throw new RunnerException("Problem moving " + string8 + " to the build folder");
                }
            }
            if (!sketchCode.isExtension("pde")) continue;
            sketchCode.addPreprocOffset(n2);
        }
        return string3;
    }

    public String build(String string) throws RunnerException {
        Compiler compiler = new Compiler();
        String string2 = this.preprocess(string);
        if (compiler.compile(this, string, string2)) {
            return string2;
        }
        return null;
    }

    protected boolean exportApplet() throws Exception {
        return this.exportApplet(new File(this.folder, "applet").getAbsolutePath());
    }

    public boolean exportApplet(String string) throws RunnerException, IOException {
        int n;
        ZipEntry zipEntry;
        CharSequence charSequence;
        Object object;
        Object object2;
        Object object3;
        int n2;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        int n3;
        this.ensureExistence();
        if (Preferences.getBoolean("editor.external")) {
            this.load();
        }
        File file = new File(string);
        if (Preferences.getBoolean("export.delete_target_folder")) {
            Base.removeDir(file);
        }
        file.mkdirs();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String string2 = this.build(file.getPath());
        if (string2 == null) {
            return false;
        }
        if (!this.name.equals(string2)) {
            Base.showWarning("Error during export", "Sketch name is " + this.name + " but the sketch\n" + "name in the code was " + string2, null);
            return false;
        }
        int n4 = 100;
        int n5 = 100;
        String string3 = "";
        String string4 = "(?:^|\\s|;)size\\s*\\(\\s*(\\S+)\\s*,\\s*(\\d+),?\\s*([^\\)]*)\\s*\\)";
        String string5 = Sketch.scrubComments(this.code[0].getProgram());
        String[] stringArray = PApplet.match((String)string5, (String)string4);
        if (stringArray != null) {
            try {
                n4 = Integer.parseInt(stringArray[1]);
                n5 = Integer.parseInt(stringArray[2]);
                if (stringArray.length == 4) {
                    string3 = stringArray[3].trim();
                }
            }
            catch (NumberFormatException numberFormatException) {
                Base.showWarning("Could not find applet size", "The size of this applet could not automatically be\ndetermined from your code. You'll have to edit the\nHTML file to set the size of the applet.\nUse only numeric values (not variables) for the size()\ncommand. See the size() reference for an explanation.", null);
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray2 = PApplet.split((String)this.code[0].getProgram(), (char)'\n');
        for (int i = 0; i < stringArray2.length; ++i) {
            if (!stringArray2[i].trim().startsWith("/**")) continue;
            for (int j = i + 1; j < stringArray2.length && !stringArray2[j].trim().endsWith("*/"); ++j) {
                for (n3 = 0; n3 < stringArray2[j].length() && (stringArray2[j].charAt(n3) == '*' || stringArray2[j].charAt(n3) == ' '); ++n3) {
                }
                stringBuffer.append(stringArray2[j].substring(n3) + "\n");
            }
        }
        String string6 = stringBuffer.toString();
        StringBuffer stringBuffer2 = new StringBuffer();
        for (n3 = 0; n3 < this.codeCount; ++n3) {
            stringBuffer2.append("<a href=\"" + this.code[n3].getFileName() + "\">" + this.code[n3].getPrettyName() + "</a> ");
        }
        for (n3 = 0; n3 < this.codeCount; ++n3) {
            try {
                object8 = new File(file, this.code[n3].getFileName());
                this.code[n3].copyTo((File)object8);
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        n3 = Preferences.getBoolean("export.applet.separate_jar_files") || this.codeFolder.exists() || this.libraryPath.length() != 0 ? 1 : 0;
        object8 = "loading.gif";
        File file2 = new File(this.folder, (String)object8);
        if (!file2.exists()) {
            object7 = new File(Base.getContentFile("lib"), "export");
            file2 = new File((File)object7, (String)object8);
        }
        Base.copyFile(file2, new File(file, (String)object8));
        object7 = new FileOutputStream(new File(file, this.name + ".jar"));
        ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)object7);
        StringBuffer stringBuffer3 = new StringBuffer();
        stringBuffer3.append(this.name + ".jar");
        this.addManifest(zipOutputStream);
        if (this.codeFolder.exists()) {
            object6 = Compiler.contentsToClassPath(this.codeFolder);
            object5 = PApplet.splitTokens((String)object6, (String)File.separator);
            object4 = "";
            for (n2 = 0; n2 < ((String[])object5).length; ++n2) {
                if (!object5[n2].toLowerCase().endsWith(".jar") && !object5[n2].toLowerCase().endsWith(".zip")) continue;
                if (n3 != 0) {
                    object3 = new File(this.codeFolder, object5[n2]);
                    object2 = ((File)object3).getName();
                    Base.copyFile((File)object3, new File(file, (String)object2));
                    continue;
                }
                object4 = (String)object4 + (String)object5[n2] + File.pathSeparatorChar;
            }
            if (n3 == 0) {
                this.packClassPathIntoZipFile((String)object4, zipOutputStream, hashMap);
            }
        }
        object6 = this.importedLibraries.iterator();
        while (object6.hasNext()) {
            object5 = (File)object6.next();
            object4 = new File((File)object5, "export.txt");
            HashMap<String, String> hashMap2 = this.readSettings((File)object4);
            object3 = hashMap2.get("applet");
            object2 = null;
            object2 = object3 != null ? PApplet.splitTokens((String)object3, (String)", ") : ((File)object5).list();
            for (int i = 0; i < ((String[])object2).length; ++i) {
                if (object2[i].equals(".") || object2[i].equals("..")) continue;
                object2[i] = PApplet.trim((String)object2[i]);
                if (object2[i].equals("")) continue;
                object = new File((File)object5, (String)object2[i]);
                if (!((File)object).exists()) {
                    System.err.println("File " + (String)object2[i] + " does not exist");
                    continue;
                }
                if (((File)object).isDirectory()) {
                    System.err.println("Ignoring sub-folder \"" + (String)object2[i] + "\"");
                    continue;
                }
                if (((File)object).getName().toLowerCase().endsWith(".zip") || ((File)object).getName().toLowerCase().endsWith(".jar")) {
                    if (n3 != 0) {
                        charSequence = ((File)object).getName();
                        Base.copyFile((File)object, new File(file, (String)charSequence));
                        if (string3.equals("OPENGL") && ((String)charSequence).indexOf("natives") != -1) continue;
                        stringBuffer3.append("," + (String)charSequence);
                        continue;
                    }
                    charSequence = ((File)object).getAbsolutePath();
                    this.packClassPathIntoZipFile((String)charSequence, zipOutputStream, hashMap);
                    continue;
                }
                Base.copyFile((File)object, new File(file, ((File)object).getName()));
            }
        }
        Object object9 = object6 = Base.isMacOS() ? Base.getContentFile("core.jar") : Base.getContentFile("lib/core.jar");
        if (n3 != 0) {
            Base.copyFile((File)object6, new File(file, "core.jar"));
            stringBuffer3.append(",core.jar");
        } else {
            object5 = ((File)object6).getAbsolutePath();
            this.packClassPathIntoZipFile((String)object5, zipOutputStream, hashMap);
        }
        if (this.dataFolder.exists()) {
            object5 = Base.listFiles(this.dataFolder, false);
            int n6 = this.folder.getAbsolutePath().length() + 1;
            for (n2 = 0; n2 < ((Object)object5).length; ++n2) {
                if (Base.isWindows()) {
                    object5[n2] = ((String)object5[n2]).replace('\\', '/');
                }
                if (((File)(object3 = new File((String)object5[n2]))).isDirectory() || ((File)object3).getName().charAt(0) == '.') continue;
                zipEntry = new ZipEntry(((String)object5[n2]).substring(n6));
                zipOutputStream.putNextEntry(zipEntry);
                zipOutputStream.write(Base.loadBytesRaw((File)object3));
                zipOutputStream.closeEntry();
            }
        }
        object5 = file.list();
        for (n = 0; n < ((Object)object5).length; ++n) {
            if (!((String)object5[n]).endsWith(".class")) continue;
            zipEntry = new ZipEntry((String)object5[n]);
            zipOutputStream.putNextEntry(zipEntry);
            zipOutputStream.write(Base.loadBytesRaw(new File(file, (String)object5[n])));
            zipOutputStream.closeEntry();
        }
        for (n = 0; n < ((Object)object5).length; ++n) {
            File file3;
            if (!((String)object5[n]).endsWith(".class") || (file3 = new File(file, (String)object5[n])).delete()) continue;
            Base.showWarning("Could not delete", (String)object5[n] + " could not \n" + "be deleted from the applet folder.  \n" + "You'll need to remove it by hand.", null);
        }
        zipOutputStream.flush();
        zipOutputStream.close();
        File file4 = new File(file, "index.html");
        PrintWriter printWriter = PApplet.createWriter((File)file4);
        object3 = null;
        object2 = new File(this.folder, "applet.html");
        if (((File)object2).exists()) {
            object3 = new FileInputStream((File)object2);
        }
        if (object3 == null) {
            object3 = string3.equals("OPENGL") ? Base.getLibStream("export/applet-opengl.html") : Base.getLibStream("export/applet.html");
        }
        BufferedReader bufferedReader = PApplet.createReader((InputStream)object3);
        object = null;
        while ((object = bufferedReader.readLine()) != null) {
            if (((String)object).indexOf("@@") != -1) {
                charSequence = new StringBuffer((String)object);
                int n7 = 0;
                while ((n7 = ((StringBuffer)charSequence).indexOf("@@sketch@@")) != -1) {
                    ((StringBuffer)charSequence).replace(n7, n7 + "@@sketch@@".length(), this.name);
                }
                while ((n7 = ((StringBuffer)charSequence).indexOf("@@source@@")) != -1) {
                    ((StringBuffer)charSequence).replace(n7, n7 + "@@source@@".length(), stringBuffer2.toString());
                }
                while ((n7 = ((StringBuffer)charSequence).indexOf("@@archive@@")) != -1) {
                    ((StringBuffer)charSequence).replace(n7, n7 + "@@archive@@".length(), stringBuffer3.toString());
                }
                while ((n7 = ((StringBuffer)charSequence).indexOf("@@width@@")) != -1) {
                    ((StringBuffer)charSequence).replace(n7, n7 + "@@width@@".length(), String.valueOf(n4));
                }
                while ((n7 = ((StringBuffer)charSequence).indexOf("@@height@@")) != -1) {
                    ((StringBuffer)charSequence).replace(n7, n7 + "@@height@@".length(), String.valueOf(n5));
                }
                while ((n7 = ((StringBuffer)charSequence).indexOf("@@description@@")) != -1) {
                    ((StringBuffer)charSequence).replace(n7, n7 + "@@description@@".length(), string6);
                }
                object = ((StringBuffer)charSequence).toString();
            }
            printWriter.println((String)object);
        }
        bufferedReader.close();
        printWriter.flush();
        printWriter.close();
        return true;
    }

    public static String scrubComments(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            if (cArray[n] == '/' && n < cArray.length - 1 && cArray[n + 1] == '/') {
                cArray[n++] = 32;
                cArray[n++] = 32;
                while (n < cArray.length && cArray[n] != '\n') {
                    cArray[n++] = 32;
                }
                continue;
            }
            if (cArray[n] == '/' && n < cArray.length - 1 && cArray[n + 1] == '*') {
                cArray[n++] = 32;
                cArray[n++] = 32;
                boolean bl = false;
                while (n < cArray.length - 1) {
                    if (cArray[n] == '*' && cArray[n + 1] == '/') {
                        cArray[n++] = 32;
                        cArray[n++] = 32;
                        bl = true;
                        break;
                    }
                    ++n;
                }
                if (bl) continue;
                throw new RuntimeException("Missing the */ from the end of a /* comment */");
            }
            ++n;
        }
        return new String(cArray);
    }

    public boolean exportApplicationPrompt() throws IOException, RunnerException {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(Box.createVerticalStrut(6));
        String string = "Export to Application creates double-clickable,";
        String string2 = "standalone applications for the selected plaforms.";
        JLabel jLabel = new JLabel(string, 0);
        JLabel jLabel2 = new JLabel(string2, 0);
        jLabel.setAlignmentX(0.0f);
        jLabel2.setAlignmentX(0.0f);
        jPanel.add(jLabel);
        jPanel.add(jLabel2);
        int n = jLabel2.getPreferredSize().width;
        jPanel.add(Box.createVerticalStrut(12));
        final JCheckBox jCheckBox = new JCheckBox("Windows");
        jCheckBox.setSelected(Preferences.getBoolean("export.application.platform.windows"));
        jCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                Preferences.setBoolean("export.application.platform.windows", jCheckBox.isSelected());
            }
        });
        final JCheckBox jCheckBox2 = new JCheckBox("Mac OS X");
        jCheckBox2.setSelected(Preferences.getBoolean("export.application.platform.macosx"));
        jCheckBox2.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                Preferences.setBoolean("export.application.platform.macosx", jCheckBox2.isSelected());
            }
        });
        final JCheckBox jCheckBox3 = new JCheckBox("Linux");
        jCheckBox3.setSelected(Preferences.getBoolean("export.application.platform.linux"));
        jCheckBox3.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                Preferences.setBoolean("export.application.platform.linux", jCheckBox3.isSelected());
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.add(jCheckBox);
        jPanel2.add(Box.createHorizontalStrut(6));
        jPanel2.add(jCheckBox2);
        jPanel2.add(Box.createHorizontalStrut(6));
        jPanel2.add(jCheckBox3);
        jPanel2.setBorder(new TitledBorder("Platforms"));
        n = Math.max(n, jPanel2.getPreferredSize().width);
        jPanel2.setAlignmentX(0.0f);
        jPanel.add(jPanel2);
        final JCheckBox jCheckBox4 = new JCheckBox("Show a Stop button");
        jCheckBox4.setSelected(Preferences.getBoolean("export.application.stop"));
        jCheckBox4.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                Preferences.setBoolean("export.application.stop", jCheckBox4.isSelected());
            }
        });
        jCheckBox4.setEnabled(Preferences.getBoolean("export.application.fullscreen"));
        jCheckBox4.setBorder(new EmptyBorder(3, 13, 6, 13));
        final JCheckBox jCheckBox5 = new JCheckBox("Full Screen (Present mode)");
        jCheckBox5.setSelected(Preferences.getBoolean("export.application.fullscreen"));
        jCheckBox5.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl = jCheckBox5.isSelected();
                Preferences.setBoolean("export.application.fullscreen", bl);
                jCheckBox4.setEnabled(bl);
            }
        });
        jCheckBox5.setBorder(new EmptyBorder(3, 13, 3, 13));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.add(jCheckBox5);
        jPanel3.add(jCheckBox4);
        jPanel3.setBorder(new TitledBorder("Options"));
        n = Math.max(n, jPanel2.getPreferredSize().width);
        jPanel3.setAlignmentX(0.0f);
        jPanel.add(jPanel3);
        Dimension dimension = new Dimension(n, jLabel.getPreferredSize().height);
        jLabel.setMaximumSize(dimension);
        dimension = new Dimension(n, jLabel2.getPreferredSize().height);
        jLabel2.setMaximumSize(dimension);
        dimension = new Dimension(n, jPanel2.getPreferredSize().height);
        jPanel2.setMaximumSize(dimension);
        dimension = new Dimension(n, jPanel3.getPreferredSize().height);
        jPanel3.setMaximumSize(dimension);
        Object[] objectArray = new String[]{"Export", "Cancel"};
        final JOptionPane jOptionPane = new JOptionPane(jPanel, -1, 0, null, objectArray, objectArray[0]);
        final JDialog jDialog = new JDialog(this.editor, "Export Options", true);
        jDialog.setContentPane(jOptionPane);
        jOptionPane.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (jDialog.isVisible() && propertyChangeEvent.getSource() == jOptionPane && string.equals("value")) {
                    jDialog.setVisible(false);
                }
            }
        });
        jDialog.pack();
        jDialog.setResizable(false);
        Rectangle rectangle = this.editor.getBounds();
        jDialog.setLocation(rectangle.x + (rectangle.width - jDialog.getSize().width) / 2, rectangle.y + (rectangle.height - jDialog.getSize().height) / 2);
        jDialog.setVisible(true);
        Object object = jOptionPane.getValue();
        if (object.equals(objectArray[0])) {
            return this.exportApplication();
        }
        if (object.equals(objectArray[1]) || object.equals(new Integer(-1))) {
            this.editor.statusNotice("Export to Application canceled.");
        }
        return false;
    }

    protected boolean exportApplication() throws IOException, RunnerException {
        String string;
        if (Preferences.getBoolean("export.application.platform.windows") && !this.exportApplication(string = new File(this.folder, "application.windows").getAbsolutePath(), 1)) {
            return false;
        }
        if (Preferences.getBoolean("export.application.platform.macosx") && !this.exportApplication(string = new File(this.folder, "application.macosx").getAbsolutePath(), 2)) {
            return false;
        }
        return !Preferences.getBoolean("export.application.platform.linux") || this.exportApplication(string = new File(this.folder, "application.linux").getAbsolutePath(), 3);
    }

    public boolean exportApplication(String string, int n) throws IOException, RunnerException {
        int n2;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        HashMap<String, Object> hashMap;
        Object object8;
        this.ensureExistence();
        if (Preferences.getBoolean("editor.external") && this.editor != null) {
            this.load();
        }
        File file = new File(string);
        if (Preferences.getBoolean("export.delete_target_folder")) {
            Base.removeDir(file);
        }
        file.mkdirs();
        String string2 = this.build(file.getPath());
        if (string2 == null) {
            return false;
        }
        if (!this.name.equals(string2)) {
            Base.showWarning("Error during export", "Sketch name is " + this.name + " but the sketch\n" + "name in the code was " + string2, null);
            return false;
        }
        File file2 = new File(file, "lib");
        File file3 = new File(Base.getContentFile("lib"), "export");
        File file4 = null;
        if (n == 2) {
            file4 = new File(file, this.name + ".app");
            object8 = "skeleton.app";
            hashMap = new File(file3, (String)object8);
            Base.copyDir(hashMap, file4);
            object7 = "Contents/MacOS/JavaApplicationStub";
            if (Base.isWindows()) {
                object6 = new File(file, "readme.txt");
                object5 = PApplet.createWriter((File)object6);
                ((PrintWriter)object5).println("This application was created on Windows, which does not");
                ((PrintWriter)object5).println("properly support setting files as \"executable\",");
                ((PrintWriter)object5).println("a necessity for applications on Mac OS X.");
                ((PrintWriter)object5).println();
                ((PrintWriter)object5).println("To fix this, use the Terminal on Mac OS X, and from this");
                ((PrintWriter)object5).println("directory, type the following:");
                ((PrintWriter)object5).println();
                ((PrintWriter)object5).println("chmod +x " + file4.getName() + "/" + (String)object7);
                ((PrintWriter)object5).flush();
                ((PrintWriter)object5).close();
            } else {
                object6 = new File(file4, (String)object7);
                object5 = ((File)object6).getAbsolutePath();
                Runtime.getRuntime().exec(new String[]{"chmod", "+x", object5});
            }
            file2 = new File(file4, "Contents/Resources/Java");
        }
        if (!file2.exists()) {
            file2.mkdirs();
        }
        if (n == 1) {
            Base.copyFile(new File(file3, "application.exe"), new File(file, this.name + ".exe"));
        }
        object8 = new Vector();
        hashMap = new HashMap();
        object7 = new FileOutputStream(new File(file2, this.name + ".jar"));
        object6 = new ZipOutputStream((OutputStream)object7);
        this.addManifest((ZipOutputStream)object6);
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].endsWith(".class")) continue;
            object5 = new ZipEntry(stringArray[i]);
            ((ZipOutputStream)object6).putNextEntry((ZipEntry)object5);
            ((FilterOutputStream)object6).write(Base.loadBytesRaw(new File(file, stringArray[i])));
            ((ZipOutputStream)object6).closeEntry();
        }
        if (this.dataFolder.exists()) {
            String[] stringArray2 = Base.listFiles(this.dataFolder, false);
            int n3 = this.folder.getAbsolutePath().length() + 1;
            for (int i = 0; i < stringArray2.length; ++i) {
                File file5;
                if (Base.isWindows()) {
                    stringArray2[i] = stringArray2[i].replace('\\', '/');
                }
                if ((file5 = new File(stringArray2[i])).isDirectory() || file5.getName().charAt(0) == '.') continue;
                object5 = new ZipEntry(stringArray2[i].substring(n3));
                ((ZipOutputStream)object6).putNextEntry((ZipEntry)object5);
                ((FilterOutputStream)object6).write(Base.loadBytesRaw(file5));
                ((ZipOutputStream)object6).closeEntry();
            }
        }
        if (this.codeFolder.exists()) {
            String string3 = Compiler.contentsToClassPath(this.codeFolder);
            String[] stringArray3 = PApplet.splitTokens((String)string3, (String)File.separator);
            String string4 = "";
            for (int i = 0; i < stringArray3.length; ++i) {
                if (stringArray3[i].toLowerCase().endsWith(".jar") || stringArray3[i].toLowerCase().endsWith(".zip")) {
                    object4 = new File(this.codeFolder, stringArray3[i]);
                    object3 = ((File)object4).getName();
                    Base.copyFile((File)object4, new File(file2, (String)object3));
                    ((Vector)object8).add(object3);
                    continue;
                }
                string4 = string4 + stringArray3[i] + File.separatorChar;
            }
            this.packClassPathIntoZipFile(string4, (ZipOutputStream)object6, hashMap);
        }
        ((DeflaterOutputStream)object6).flush();
        ((ZipOutputStream)object6).close();
        ((Vector)object8).add(this.name + ".jar");
        File file6 = Base.isMacOS() ? Base.getContentFile("core.jar") : Base.getContentFile("lib/core.jar");
        Base.copyFile(file6, new File(file2, "core.jar"));
        ((Vector)object8).add("core.jar");
        for (File file7 : this.importedLibraries) {
            File file8 = new File(file7, "export.txt");
            object4 = this.readSettings(file8);
            object3 = null;
            object2 = null;
            object3 = n == 2 ? (String)((HashMap)object4).get("application.macosx") : (n == 1 ? (String)((HashMap)object4).get("application.windows") : (n == 3 ? (String)((HashMap)object4).get("application.linux") : (String)((HashMap)object4).get("application")));
            object2 = object3 == null ? file7.list() : PApplet.splitTokens((String)object3, (String)", ");
            for (int i = 0; i < ((String[])object2).length; ++i) {
                if (object2[i].equals(".") || object2[i].equals("..")) continue;
                object2[i] = PApplet.trim((String)object2[i]);
                if (object2[i].equals("")) continue;
                object = new File(file7, object2[i]);
                if (!((File)object).exists()) {
                    System.err.println("File " + object2[i] + " does not exist");
                    continue;
                }
                if (((File)object).isDirectory()) {
                    if (n == 2) {
                        Base.copyDir((File)object, new File(file2, ((File)object).getName()));
                        continue;
                    }
                    Base.copyDir((File)object, new File(file, ((File)object).getName()));
                    continue;
                }
                if (((File)object).getName().toLowerCase().endsWith(".zip") || ((File)object).getName().toLowerCase().endsWith(".jar")) {
                    Base.copyFile((File)object, new File(file2, object2[i]));
                    ((Vector)object8).add(object2[i]);
                    continue;
                }
                if (n == 2 && ((File)object).getName().toLowerCase().endsWith(".jnilib")) {
                    Base.copyFile((File)object, new File(file2, (String)object2[i]));
                    continue;
                }
                Base.copyFile((File)object, new File(file, ((File)object).getName()));
            }
        }
        Object[] objectArray = new String[((Vector)object8).size()];
        ((Vector)object8).copyInto(objectArray);
        StringBuffer stringBuffer = new StringBuffer();
        if (n == 2) {
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                if (n2 != 0) {
                    stringBuffer.append(":");
                }
                stringBuffer.append("$JAVAROOT/" + (String)objectArray[n2]);
            }
        } else if (n == 1) {
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                if (n2 != 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append((String)objectArray[n2]);
            }
        } else {
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                if (n2 != 0) {
                    stringBuffer.append(":");
                }
                stringBuffer.append("$APPDIR/lib/" + (String)objectArray[n2]);
            }
        }
        String string5 = Preferences.get("run.options");
        if (Preferences.getBoolean("run.options.memory")) {
            string5 = string5 + " -Xms" + Preferences.get("run.options.memory.initial") + "m";
            string5 = string5 + " -Xmx" + Preferences.get("run.options.memory.maximum") + "m";
        }
        if (n == 2) {
            object4 = "template.plist";
            object3 = new File(this.folder, (String)object4);
            if (!((File)object3).exists()) {
                object3 = new File(file3, (String)object4);
            }
            object2 = new File(file4, "Contents/Info.plist");
            PrintWriter printWriter = PApplet.createWriter((File)object2);
            object = PApplet.loadStrings((File)object3);
            for (int i = 0; i < ((String[])object).length; ++i) {
                if (object[i].indexOf("@@") != -1) {
                    StringBuffer stringBuffer2 = new StringBuffer(object[i]);
                    int n4 = 0;
                    while ((n4 = stringBuffer2.indexOf("@@vmoptions@@")) != -1) {
                        stringBuffer2.replace(n4, n4 + "@@vmoptions@@".length(), string5);
                    }
                    while ((n4 = stringBuffer2.indexOf("@@sketch@@")) != -1) {
                        stringBuffer2.replace(n4, n4 + "@@sketch@@".length(), this.name);
                    }
                    while ((n4 = stringBuffer2.indexOf("@@classpath@@")) != -1) {
                        stringBuffer2.replace(n4, n4 + "@@classpath@@".length(), stringBuffer.toString());
                    }
                    while ((n4 = stringBuffer2.indexOf("@@lsuipresentationmode@@")) != -1) {
                        stringBuffer2.replace(n4, n4 + "@@lsuipresentationmode@@".length(), Preferences.getBoolean("export.application.fullscreen") ? "4" : "0");
                    }
                    object[i] = stringBuffer2.toString();
                }
                printWriter.print((String)object[i] + "\n");
            }
            printWriter.flush();
            printWriter.close();
        } else if (n == 1) {
            object4 = new File(file + "/lib/args.txt");
            object3 = PApplet.createWriter((File)object4);
            ((PrintWriter)object3).println(string5);
            ((PrintWriter)object3).println(this.name);
            ((PrintWriter)object3).println(stringBuffer);
            ((PrintWriter)object3).flush();
            ((PrintWriter)object3).close();
        } else {
            object4 = new File(file, this.name);
            object3 = PApplet.createWriter((File)object4);
            ((PrintWriter)object3).print("#!/bin/sh\n\n");
            ((PrintWriter)object3).print("APPDIR=$(dirname \"$0\")\n");
            ((PrintWriter)object3).print("java " + Preferences.get("run.options") + " -Djava.library.path=\"$APPDIR\"" + " -cp \"" + stringBuffer + "\"" + " " + this.name + "\n");
            ((PrintWriter)object3).flush();
            ((PrintWriter)object3).close();
            object2 = ((File)object4).getAbsolutePath();
            if (!Base.isWindows()) {
                Runtime.getRuntime().exec(new String[]{"chmod", "+x", object2});
            }
        }
        object4 = new File(file, "source");
        ((File)object4).mkdirs();
        for (int i = 0; i < this.codeCount; ++i) {
            try {
                this.code[i].copyTo(new File((File)object4, this.code[i].getFileName()));
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        String string6 = this.name + ".java";
        object2 = new File(file, string6);
        if (((File)object2).exists()) {
            ((File)object2).renameTo(new File((File)object4, string6));
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].endsWith(".class") || ((File)(object = new File(file, stringArray[i]))).delete()) continue;
            Base.showWarning("Could not delete", stringArray[i] + " could not \n" + "be deleted from the applet folder.  \n" + "You'll need to remove it by hand.", null);
        }
        return true;
    }

    protected void addManifest(ZipOutputStream zipOutputStream) throws IOException {
        ZipEntry zipEntry = new ZipEntry("META-INF/MANIFEST.MF");
        zipOutputStream.putNextEntry(zipEntry);
        String string = "Manifest-Version: 1.0\nCreated-By: Processing " + Base.VERSION_NAME + "\n" + "Main-Class: " + this.name + "\n";
        zipOutputStream.write(string.getBytes());
        zipOutputStream.closeEntry();
    }

    protected HashMap<String, String> readSettings(File file) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (!file.exists()) {
            return hashMap;
        }
        String[] stringArray = PApplet.loadStrings((File)file);
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            int n = stringArray[i].indexOf(35);
            String string2 = string = n == -1 ? stringArray[i].trim() : stringArray[i].substring(0, n).trim();
            if (string.length() == 0) continue;
            int n2 = string.indexOf(61);
            if (n2 == -1) {
                System.err.println("ignoring illegal line in " + file);
                System.err.println("  " + string);
                continue;
            }
            String string3 = string.substring(0, n2).trim();
            String string4 = string.substring(n2 + 1).trim();
            hashMap.put(string3, string4);
        }
        return hashMap;
    }

    protected void packClassPathIntoZipFile(String string, ZipOutputStream zipOutputStream, HashMap<String, Object> hashMap) throws IOException {
        String[] stringArray = PApplet.split((String)string, (char)File.pathSeparatorChar);
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            if (stringArray[i].length() == 0) continue;
            if (stringArray[i].toLowerCase().endsWith(".jar") || stringArray[i].toLowerCase().endsWith(".zip")) {
                try {
                    object = new ZipFile(stringArray[i]);
                    Enumeration<? extends ZipEntry> enumeration = ((ZipFile)object).entries();
                    while (enumeration.hasMoreElements()) {
                        int n;
                        String string2;
                        ZipEntry zipEntry = enumeration.nextElement();
                        if (zipEntry.isDirectory() || (string2 = zipEntry.getName()).indexOf("META-INF") == 0 || hashMap.get(string2) != null) continue;
                        hashMap.put(string2, new Object());
                        ZipEntry zipEntry2 = new ZipEntry(string2);
                        zipOutputStream.putNextEntry(zipEntry2);
                        byte[] byArray = new byte[(int)zipEntry.getSize()];
                        InputStream inputStream = ((ZipFile)object).getInputStream(zipEntry);
                        int n2 = 0;
                        for (int j = byArray.length; j > 0; j -= n) {
                            n = inputStream.read(byArray, n2, j);
                            n2 += n;
                        }
                        zipOutputStream.write(byArray);
                        zipOutputStream.flush();
                        zipOutputStream.closeEntry();
                    }
                    continue;
                }
                catch (IOException iOException) {
                    System.err.println("Error in file " + stringArray[i]);
                    iOException.printStackTrace();
                    continue;
                }
            }
            object = new File(stringArray[i]);
            if (!((File)object).exists()) continue;
            Sketch.packClassPathIntoZipFileRecursive((File)object, null, zipOutputStream);
        }
    }

    protected static void packClassPathIntoZipFileRecursive(File file, String string, ZipOutputStream zipOutputStream) throws IOException {
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2;
            if (stringArray[i].charAt(0) == '.') continue;
            File file2 = new File(file, stringArray[i]);
            String string3 = string2 = string == null ? stringArray[i] : string + "/" + stringArray[i];
            if (file2.isDirectory()) {
                Sketch.packClassPathIntoZipFileRecursive(file2, string2, zipOutputStream);
                continue;
            }
            if (stringArray[i].toLowerCase().endsWith(".jar") || stringArray[i].toLowerCase().endsWith(".zip") || stringArray[i].charAt(0) == '.') continue;
            ZipEntry zipEntry = new ZipEntry(string2);
            zipOutputStream.putNextEntry(zipEntry);
            zipOutputStream.write(Base.loadBytesRaw(file2));
            zipOutputStream.closeEntry();
        }
    }

    protected void ensureExistence() {
        if (this.folder.exists()) {
            return;
        }
        Base.showWarning("Sketch Disappeared", "The sketch folder has disappeared.\n Will attempt to re-save in the same location,\nbut anything besides the code will be lost.", null);
        try {
            this.folder.mkdirs();
            this.modified = true;
            for (int i = 0; i < this.codeCount; ++i) {
                this.code[i].save();
            }
            this.calcModified();
        }
        catch (Exception exception) {
            Base.showWarning("Could not re-save sketch", "Could not properly re-save the sketch. You may be in trouble at this point,\nand it might be time to copy and paste your code to another text editor.", exception);
        }
    }

    public boolean isReadOnly() {
        String string = this.folder.getAbsolutePath();
        if (string.startsWith(Base.getExamplesPath()) || string.startsWith(Base.getLibrariesPath())) {
            return true;
        }
        for (int i = 0; i < this.codeCount; ++i) {
            if (!this.code[i].isModified() || !this.code[i].fileReadOnly() || !this.code[i].fileExists()) continue;
            return true;
        }
        return false;
    }

    public boolean hideExtension(String string) {
        return string.equals(this.getDefaultExtension());
    }

    public boolean hasDefaultExtension(SketchCode sketchCode) {
        return sketchCode.getExtension().equals(this.getDefaultExtension());
    }

    public boolean isDefaultExtension(String string) {
        return string.equals(this.getDefaultExtension());
    }

    public boolean validExtension(String string) {
        String[] stringArray = this.getExtensions();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public String getDefaultExtension() {
        return "pde";
    }

    public String[] getExtensions() {
        return new String[]{"pde", "java"};
    }

    public String getName() {
        return this.name;
    }

    public File getPrimaryFile() {
        return this.primaryFile;
    }

    public String getMainFilePath() {
        return this.primaryFile.getAbsolutePath();
    }

    public File getFolder() {
        return this.folder;
    }

    public File getDataFolder() {
        return this.dataFolder;
    }

    public File prepareDataFolder() {
        if (!this.dataFolder.exists()) {
            this.dataFolder.mkdirs();
        }
        return this.dataFolder;
    }

    public File getCodeFolder() {
        return this.codeFolder;
    }

    public File prepareCodeFolder() {
        if (!this.codeFolder.exists()) {
            this.codeFolder.mkdirs();
        }
        return this.codeFolder;
    }

    public String getClassPath() {
        return this.classPath;
    }

    public String getLibraryPath() {
        return this.libraryPath;
    }

    public SketchCode[] getCode() {
        return this.code;
    }

    public int getCodeCount() {
        return this.codeCount;
    }

    public SketchCode getCode(int n) {
        return this.code[n];
    }

    public int getCodeIndex(SketchCode sketchCode) {
        for (int i = 0; i < this.codeCount; ++i) {
            if (sketchCode != this.code[i]) continue;
            return i;
        }
        return -1;
    }

    public SketchCode getCurrentCode() {
        return this.current;
    }

    public void setUntitled(boolean bl) {
        this.editor.untitled = bl;
    }

    public boolean isUntitled() {
        return this.editor.untitled;
    }

    public String getAppletClassName2() {
        return this.appletClassName;
    }

    public static String checkName(String string) {
        String string2 = Sketch.sanitizeName(string);
        if (!string2.equals(string)) {
            String string3 = "The sketch name had to be modified. Sketch names can only consist\nof ASCII characters and numbers (but cannot start with a number).\nThey should also be less less than 64 characters long.";
            System.out.println(string3);
        }
        return string2;
    }

    public static boolean isSanitaryName(String string) {
        return Sketch.sanitizeName(string).equals(string);
    }

    public static String sanitizeName(String string) {
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        if (cArray[0] >= '0' && cArray[0] <= '9') {
            stringBuffer.append('_');
        }
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] >= '0' && cArray[i] <= '9' || cArray[i] >= 'a' && cArray[i] <= 'z' || cArray[i] >= 'A' && cArray[i] <= 'Z') {
                stringBuffer.append(cArray[i]);
                continue;
            }
            stringBuffer.append('_');
        }
        if (stringBuffer.length() > 63) {
            stringBuffer.setLength(63);
        }
        return stringBuffer.toString();
    }
}

