/*
 * Decompiled with CFR 0.152.
 */
package processing.app.preproc;

import antlr.ASTFactory;
import antlr.CommonAST;
import antlr.TokenStreamCopyingHiddenTokenFilter;
import antlr.collections.AST;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import processing.app.Preferences;
import processing.app.Sketch;
import processing.app.preproc.PdeEmitter;
import processing.app.preproc.PdeLexer;
import processing.app.preproc.PdeRecognizer;
import processing.core.PApplet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdePreprocessor {
    String[] defaultImports;
    ArrayList<String> programImports;
    ArrayList<String> codeFolderImports;
    public static final int STATIC = 0;
    public static final int ACTIVE = 1;
    public static final int JAVA = 2;
    public static int programType;
    public static boolean foundMain;
    String indent;
    PrintStream stream;
    Reader programReader;
    String buildPath;
    String name;
    private static final int ROOT_ID = 0;
    public static TokenStreamCopyingHiddenTokenFilter filter;
    static String advClassName;

    /*
     * WARNING - void declaration
     */
    public int writePrefix(String string, String string2, String string3, String[] stringArray) throws FileNotFoundException {
        String[] stringArray2;
        int n;
        int n2;
        Object object;
        Object object3;
        this.buildPath = string2;
        this.name = string3;
        int n3 = Preferences.getInteger("editor.tabs.size");
        char[] cArray = new char[n3];
        Arrays.fill(cArray, ' ');
        this.indent = new String(cArray);
        foundMain = false;
        string = string + "\n";
        Sketch.scrubComments(string);
        if (Preferences.getBoolean("preproc.substitute_unicode")) {
            void object2;
            object3 = string.toCharArray();
            int n5 = 0;
            boolean n4 = false;
            while (object2 < ((char[])object3).length) {
                if (object3[object2] > '\u007f') {
                    ++n5;
                }
                ++object2;
            }
            if (n5 != 0) {
                void var9_13;
                boolean bl = false;
                object = new char[((char[])object3).length + n5 * 5];
                for (n2 = 0; n2 < ((char[])object3).length; ++n2) {
                    if (object3[n2] < '\u0080') {
                        object[var9_13++] = object3[n2];
                        continue;
                    }
                    if (object3[n2] == '\u00a0') {
                        object[var9_13++] = 32;
                        continue;
                    }
                    n = object3[n2];
                    object[var9_13++] = 92;
                    object[var9_13++] = 117;
                    char[] cArray2 = Integer.toHexString(n).toCharArray();
                    for (int i = 0; i < 4 - cArray2.length; ++i) {
                        object[var9_13++] = 48;
                    }
                    System.arraycopy(cArray2, 0, object, (int)var9_13, cArray2.length);
                    var9_13 += cArray2.length;
                }
                string = new String((char[])object, 0, (int)var9_13);
            }
        }
        object3 = Preferences.get("preproc.imports");
        this.defaultImports = PApplet.splitTokens((String)object3, (String)", ");
        String string4 = "(?:^|;)\\s*(import\\s+)(\\S+)(\\s*;)";
        this.programImports = new ArrayList();
        while ((stringArray2 = PApplet.match((String)string, (String)string4)) != null) {
            object = stringArray2[1] + stringArray2[2] + stringArray2[3];
            n2 = ((String)object).length();
            this.programImports.add(stringArray2[2]);
            n = string.indexOf((String)object);
            string = string.substring(0, n) + string.substring(n + n2);
        }
        this.codeFolderImports = new ArrayList();
        if (stringArray != null) {
            for (String string5 : stringArray) {
                this.codeFolderImports.add(string5 + ".*");
            }
        }
        this.programReader = new StringReader(string);
        File file = new File(string2, string3 + ".java");
        this.stream = new PrintStream(new FileOutputStream(file));
        int n4 = this.writeImports(this.stream);
        return n4 + 2;
    }

    public String write() throws Exception {
        PdeLexer pdeLexer = new PdeLexer(this.programReader);
        pdeLexer.setTokenObjectClass("antlr.CommonHiddenStreamToken");
        filter = new TokenStreamCopyingHiddenTokenFilter(pdeLexer);
        filter.hide(146);
        filter.hide(147);
        filter.hide(145);
        filter.copy(45);
        filter.copy(77);
        filter.copy(78);
        filter.copy(73);
        filter.copy(74);
        filter.copy(75);
        filter.copy(48);
        filter.copy(47);
        filter.copy(83);
        PdeRecognizer pdeRecognizer = new PdeRecognizer(filter);
        pdeRecognizer.setASTNodeClass("antlr.ExtendedCommonASTWithHiddenTokens");
        pdeRecognizer.pdeProgram();
        ASTFactory aSTFactory = new ASTFactory();
        AST aST = pdeRecognizer.getAST();
        AST aST2 = aSTFactory.create(0, "AST ROOT");
        aST2.setFirstChild(aST);
        CommonAST.setVerboseStringConversion((boolean)true, (String[])pdeRecognizer.getTokenNames());
        if (programType == 2) {
            this.name = this.getFirstClassName(aST);
        }
        if (this.name == null) {
            return null;
        }
        PdeEmitter pdeEmitter = new PdeEmitter();
        this.writeDeclaration(this.stream, this.name);
        pdeEmitter.setOut(this.stream);
        pdeEmitter.print(aST2);
        this.writeFooter(this.stream, this.name);
        this.stream.close();
        if (Preferences.getBoolean("preproc.output_parse_tree")) {
            this.writeParseTree("parseTree.xml", aST);
        }
        return this.name;
    }

    protected void writeParseTree(String string, AST aST) {
        try {
            PrintStream printStream = new PrintStream(new FileOutputStream(string));
            printStream.println("<?xml version=\"1.0\"?>");
            printStream.println("<document>");
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(printStream);
            if (aST != null) {
                ((CommonAST)aST).xmlSerialize((Writer)outputStreamWriter);
            }
            outputStreamWriter.flush();
            printStream.println("</document>");
            outputStreamWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected int writeImports(PrintStream printStream) {
        printStream.println("import processing.core.*; ");
        printStream.println("import processing.xml.*; ");
        printStream.println();
        int n = 3;
        if (this.programImports.size() != 0) {
            for (String string : this.programImports) {
                printStream.println("import " + string + "; ");
            }
            printStream.println();
            n += this.programImports.size() + 1;
        }
        if (this.codeFolderImports.size() != 0) {
            for (String string : this.codeFolderImports) {
                printStream.println("import " + string + "; ");
            }
            printStream.println();
            n += this.codeFolderImports.size() + 1;
        }
        for (String string : this.defaultImports) {
            printStream.println("import " + (String)string + ".*; ");
        }
        printStream.println();
        return n += this.defaultImports.length + 1;
    }

    protected void writeDeclaration(PrintStream printStream, String string) {
        String string2 = "  ";
        if (programType == 2) {
            printStream.println();
            printStream.println();
        } else if (programType == 1) {
            printStream.println("public class " + string + " extends PApplet {");
            printStream.println();
        } else if (programType == 0) {
            printStream.println("public class " + string + " extends PApplet {");
            printStream.println(string2 + "public void setup() {");
        }
    }

    protected void writeFooter(PrintStream printStream, String string) {
        if (programType == 0) {
            printStream.println(this.indent + "noLoop();");
            printStream.println("} ");
        }
        if (programType == 0 || programType == 1) {
            if (!foundMain) {
                printStream.println(this.indent + "static public void main(String args[]) {");
                printStream.print(this.indent + this.indent + "PApplet.main(new String[] { ");
                if (Preferences.getBoolean("export.application.fullscreen")) {
                    printStream.print("\"--present\", ");
                    String string2 = Preferences.get("run.present.bgcolor");
                    printStream.print("\"--bgcolor=" + string2 + "\", ");
                    if (Preferences.getBoolean("export.application.stop")) {
                        string2 = Preferences.get("run.present.stop.color");
                        printStream.print("\"--stop-color=" + string2 + "\", ");
                    } else {
                        printStream.print("\"--hide-stop\", ");
                    }
                } else {
                    String string3 = Preferences.get("run.window.bgcolor");
                    printStream.print("\"--bgcolor=" + string3 + "\", ");
                }
                printStream.println("\"" + string + "\" });");
                printStream.println(this.indent + "}");
            }
            printStream.println("}");
        }
    }

    public ArrayList<String> getExtraImports() {
        return this.programImports;
    }

    String getFirstClassName(AST aST) {
        String string = advClassName;
        advClassName = "";
        return string;
    }

    static {
        advClassName = "";
    }
}

