/*
 * Decompiled with CFR 0.152.
 */
package processing.app.preproc;

import antlr.CommonASTWithHiddenTokens;
import antlr.CommonHiddenStreamToken;
import antlr.collections.AST;
import java.io.PrintStream;
import java.util.Stack;
import processing.app.Preferences;
import processing.app.debug.RunnerException;
import processing.app.preproc.PdePreprocessor;
import processing.app.preproc.PdeTokenTypes;

public class PdeEmitter
implements PdeTokenTypes {
    private PrintStream out = System.out;
    private PrintStream debug = System.err;
    private Stack stack = new Stack();
    private static String[] tokenNames;
    private static final int ROOT_ID = 0;

    private static void setupTokenNames() {
        tokenNames = new String[200];
        for (int i = 0; i < tokenNames.length; ++i) {
            PdeEmitter.tokenNames[i] = "ERROR:" + i;
        }
        PdeEmitter.tokenNames[25] = "++";
        PdeEmitter.tokenNames[26] = "--";
        PdeEmitter.tokenNames[31] = "-";
        PdeEmitter.tokenNames[32] = "+";
        PdeEmitter.tokenNames[60] = "*";
        PdeEmitter.tokenNames[81] = "=";
        PdeEmitter.tokenNames[100] = "+=";
        PdeEmitter.tokenNames[101] = "-=";
        PdeEmitter.tokenNames[102] = "*=";
        PdeEmitter.tokenNames[103] = "/=";
        PdeEmitter.tokenNames[104] = "%=";
        PdeEmitter.tokenNames[105] = ">>=";
        PdeEmitter.tokenNames[106] = ">>>=";
        PdeEmitter.tokenNames[107] = "<<=";
        PdeEmitter.tokenNames[108] = "&=";
        PdeEmitter.tokenNames[109] = "^=";
        PdeEmitter.tokenNames[110] = "|=";
        PdeEmitter.tokenNames[111] = "?";
        PdeEmitter.tokenNames[112] = "||";
        PdeEmitter.tokenNames[113] = "&&";
        PdeEmitter.tokenNames[114] = "|";
        PdeEmitter.tokenNames[115] = "^";
        PdeEmitter.tokenNames[116] = "&";
        PdeEmitter.tokenNames[117] = "!=";
        PdeEmitter.tokenNames[118] = "==";
        PdeEmitter.tokenNames[119] = "<";
        PdeEmitter.tokenNames[120] = ">";
        PdeEmitter.tokenNames[121] = "<=";
        PdeEmitter.tokenNames[122] = ">=";
        PdeEmitter.tokenNames[124] = "<<";
        PdeEmitter.tokenNames[125] = ">>";
        PdeEmitter.tokenNames[126] = ">>>";
        PdeEmitter.tokenNames[127] = "+";
        PdeEmitter.tokenNames[128] = "-";
        PdeEmitter.tokenNames[129] = "/";
        PdeEmitter.tokenNames[130] = "%";
        PdeEmitter.tokenNames[131] = "++";
        PdeEmitter.tokenNames[132] = "--";
        PdeEmitter.tokenNames[133] = "~";
        PdeEmitter.tokenNames[134] = "!";
        PdeEmitter.tokenNames[39] = "final";
        PdeEmitter.tokenNames[40] = "abstract";
        PdeEmitter.tokenNames[44] = "package";
        PdeEmitter.tokenNames[46] = "import";
        PdeEmitter.tokenNames[49] = "void";
        PdeEmitter.tokenNames[50] = "boolean";
        PdeEmitter.tokenNames[51] = "byte";
        PdeEmitter.tokenNames[52] = "char";
        PdeEmitter.tokenNames[53] = "short";
        PdeEmitter.tokenNames[54] = "int";
        PdeEmitter.tokenNames[55] = "float";
        PdeEmitter.tokenNames[56] = "long";
        PdeEmitter.tokenNames[57] = "double";
        PdeEmitter.tokenNames[61] = "private";
        PdeEmitter.tokenNames[62] = "public";
        PdeEmitter.tokenNames[63] = "protected";
        PdeEmitter.tokenNames[64] = "static";
        PdeEmitter.tokenNames[65] = "transient";
        PdeEmitter.tokenNames[66] = "native";
        PdeEmitter.tokenNames[67] = "threadsafe";
        PdeEmitter.tokenNames[68] = "synchronized";
        PdeEmitter.tokenNames[69] = "volatile";
        PdeEmitter.tokenNames[70] = "class";
        PdeEmitter.tokenNames[71] = "extends";
        PdeEmitter.tokenNames[72] = "interface";
        PdeEmitter.tokenNames[76] = "implements";
        PdeEmitter.tokenNames[82] = "throws";
        PdeEmitter.tokenNames[84] = "if";
        PdeEmitter.tokenNames[85] = "else";
        PdeEmitter.tokenNames[86] = "for";
        PdeEmitter.tokenNames[87] = "while";
        PdeEmitter.tokenNames[88] = "do";
        PdeEmitter.tokenNames[89] = "break";
        PdeEmitter.tokenNames[90] = "continue";
        PdeEmitter.tokenNames[91] = "return";
        PdeEmitter.tokenNames[92] = "switch";
        PdeEmitter.tokenNames[93] = "throw";
        PdeEmitter.tokenNames[95] = "case";
        PdeEmitter.tokenNames[96] = "default";
        PdeEmitter.tokenNames[97] = "try";
        PdeEmitter.tokenNames[98] = "finally";
        PdeEmitter.tokenNames[99] = "catch";
        PdeEmitter.tokenNames[123] = "instanceof";
        PdeEmitter.tokenNames[79] = "this";
        PdeEmitter.tokenNames[80] = "super";
        PdeEmitter.tokenNames[135] = "true";
        PdeEmitter.tokenNames[136] = "false";
        PdeEmitter.tokenNames[137] = "null";
        PdeEmitter.tokenNames[138] = "new";
        PdeEmitter.tokenNames[156] = "int";
    }

    public void setOut(PrintStream printStream) {
        this.out = printStream;
    }

    private String name(AST aST) {
        return tokenNames[aST.getType()];
    }

    private String name(int n) {
        return tokenNames[n];
    }

    private AST getChild(AST aST, int n) {
        for (AST aST2 = aST.getFirstChild(); aST2 != null; aST2 = aST2.getNextSibling()) {
            if (aST2.getType() != n) continue;
            return aST2;
        }
        return null;
    }

    private void dumpHiddenAfter(AST aST) {
        this.dumpHiddenTokens(((CommonASTWithHiddenTokens)aST).getHiddenAfter());
    }

    private void dumpHiddenBefore(AST aST) {
        CommonHiddenStreamToken commonHiddenStreamToken = null;
        CommonHiddenStreamToken commonHiddenStreamToken2 = ((CommonASTWithHiddenTokens)aST).getHiddenBefore();
        if (commonHiddenStreamToken2 == null) {
            return;
        }
        while ((commonHiddenStreamToken2 = (commonHiddenStreamToken = commonHiddenStreamToken2).getHiddenBefore()) != null) {
        }
        this.dumpHiddenTokens(commonHiddenStreamToken);
    }

    private void dumpHiddenTokens(CommonHiddenStreamToken commonHiddenStreamToken) {
        while (commonHiddenStreamToken != null) {
            this.out.print(commonHiddenStreamToken.getText());
            commonHiddenStreamToken = PdePreprocessor.filter.getHiddenAfter(commonHiddenStreamToken);
        }
    }

    private boolean printChildren(AST aST) throws RunnerException {
        boolean bl = false;
        for (AST aST2 = aST.getFirstChild(); aST2 != null; aST2 = aST2.getNextSibling()) {
            bl = true;
            this.print(aST2);
        }
        return bl;
    }

    private boolean hasChildren(AST aST) {
        return aST.getFirstChild() != null;
    }

    private AST getBestPrintableNode(AST aST, boolean bl) {
        AST aST2 = bl ? aST : aST.getFirstChild();
        if (aST2 != null) {
            switch (aST2.getType()) {
                case 14: 
                case 31: 
                case 32: 
                case 68: 
                case 84: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 97: 
                case 131: 
                case 132: 
                case 133: 
                case 134: {
                    return aST2;
                }
                case 5: {
                    if (aST2.getFirstChild() == null) {
                        return this.getBestPrintableNode(aST2.getNextSibling(), false);
                    }
                    return this.getBestPrintableNode(aST2, false);
                }
            }
            return this.getBestPrintableNode(aST2, false);
        }
        return aST;
    }

    private void printBinaryOperator(AST aST) throws RunnerException {
        this.print(aST.getFirstChild());
        this.out.print(this.name(aST));
        this.dumpHiddenAfter(aST);
        this.print(aST.getFirstChild().getNextSibling());
    }

    public void print(AST aST) throws RunnerException {
        if (aST == null) {
            return;
        }
        AST aST2 = null;
        if (!this.stack.isEmpty()) {
            aST2 = (AST)this.stack.peek();
        }
        this.stack.push(aST);
        AST aST3 = aST.getFirstChild();
        AST aST4 = null;
        AST aST5 = null;
        if (aST3 != null && (aST4 = aST3.getNextSibling()) != null) {
            aST5 = aST4.getNextSibling();
        }
        switch (aST.getType()) {
            case 0: {
                this.dumpHiddenTokens(PdePreprocessor.filter.getInitialHiddenToken());
                this.printChildren(aST);
                break;
            }
            case 16: {
                this.out.print("package");
                this.dumpHiddenAfter(aST);
                this.print(aST.getFirstChild());
                break;
            }
            case 30: {
                this.out.print("import");
                this.dumpHiddenAfter(aST);
                this.print(aST.getFirstChild());
                break;
            }
            case 14: 
            case 15: {
                this.print(this.getChild(aST, 5));
                if (aST.getType() == 14) {
                    this.out.print("class");
                } else {
                    this.out.print("interface");
                }
                this.dumpHiddenBefore(this.getChild(aST, 58));
                this.print(this.getChild(aST, 58));
                this.print(this.getChild(aST, 18));
                this.print(this.getChild(aST, 19));
                this.print(this.getChild(aST, 6));
                break;
            }
            case 18: {
                if (!this.hasChildren(aST)) break;
                this.out.print("extends");
                this.dumpHiddenBefore(this.getBestPrintableNode(aST, false));
                this.printChildren(aST);
                break;
            }
            case 19: {
                if (!this.hasChildren(aST)) break;
                this.out.print("implements");
                this.dumpHiddenBefore(this.getBestPrintableNode(aST, false));
                this.printChildren(aST);
                break;
            }
            case 59: {
                this.print(aST3);
                this.out.print(".");
                this.dumpHiddenAfter(aST);
                this.print(aST4);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 17: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 42: 
            case 43: {
                this.printChildren(aST);
                break;
            }
            case 9: {
                AST aST6 = aST.getFirstChild();
                AST aST7 = aST6.getNextSibling();
                AST aST8 = aST7.getNextSibling();
                AST aST9 = aST8.getNextSibling();
                String string = aST8.getText();
                if (string.equals("main")) {
                    PdePreprocessor.foundMain = true;
                }
                boolean bl = false;
                AST aST10 = aST6.getFirstChild();
                while (aST10 != null) {
                    String string2 = aST10.getText();
                    if (string2.equals("public") || string2.equals("protected") || string2.equals("private")) {
                        bl = true;
                        aST10 = null;
                        continue;
                    }
                    aST10 = aST10.getNextSibling();
                }
                if (!bl) {
                    this.out.print("public ");
                }
                this.printChildren(aST);
                break;
            }
            case 81: {
                if (aST4 != null) {
                    this.print(aST3);
                    this.out.print("=");
                    this.dumpHiddenAfter(aST);
                    this.print(aST4);
                    break;
                }
                this.out.print("=");
                this.dumpHiddenAfter(aST);
                this.print(aST3);
                break;
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: {
                this.printBinaryOperator(aST);
                break;
            }
            case 86: {
                this.out.print(this.name(aST));
                this.dumpHiddenAfter(aST);
                this.printChildren(aST);
                break;
            }
            case 25: 
            case 26: {
                this.print(aST3);
                this.out.print(this.name(aST));
                this.dumpHiddenAfter(aST);
                break;
            }
            case 31: 
            case 32: 
            case 131: 
            case 132: 
            case 133: 
            case 134: {
                this.out.print(this.name(aST));
                this.dumpHiddenAfter(aST);
                this.print(aST3);
                break;
            }
            case 138: {
                this.out.print("new");
                this.dumpHiddenAfter(aST);
                this.print(aST3);
                this.print(aST4);
                if (aST5 == null) break;
                this.print(aST5);
                break;
            }
            case 91: {
                this.out.print("return");
                this.dumpHiddenAfter(aST);
                this.print(aST3);
                break;
            }
            case 12: {
                this.out.print("static");
                this.dumpHiddenBefore(this.getBestPrintableNode(aST, false));
                this.print(aST3);
                break;
            }
            case 92: {
                this.out.print("switch");
                this.dumpHiddenAfter(aST);
                this.printChildren(aST);
                break;
            }
            case 33: {
                this.printChildren(aST);
                break;
            }
            case 95: {
                this.out.print("case");
                this.dumpHiddenAfter(aST);
                this.printChildren(aST);
                break;
            }
            case 96: {
                this.out.print("default");
                this.dumpHiddenAfter(aST);
                this.printChildren(aST);
                break;
            }
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: {
                this.out.print(aST.getText());
                this.dumpHiddenAfter(aST);
                break;
            }
            case 68: {
                this.out.print(this.name(aST));
                this.dumpHiddenAfter(aST);
                this.printChildren(aST);
                break;
            }
            case 39: 
            case 40: 
            case 44: 
            case 45: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 69: 
            case 79: 
            case 80: 
            case 89: 
            case 90: 
            case 135: 
            case 136: 
            case 137: {
                this.out.print(this.name(aST));
                this.dumpHiddenAfter(aST);
                break;
            }
            case 38: 
            case 154: {
                break;
            }
            case 60: {
                if (this.hasChildren(aST)) {
                    this.printBinaryOperator(aST);
                    break;
                }
                this.out.print("*");
                this.dumpHiddenAfter(aST);
                break;
            }
            case 82: {
                this.out.print("throws");
                this.dumpHiddenAfter(aST);
                this.printChildren(aST);
                break;
            }
            case 84: {
                this.out.print("if");
                this.dumpHiddenAfter(aST);
                this.print(aST3);
                this.print(aST4);
                if (aST5 == null) break;
                this.out.print("else");
                this.dumpHiddenBefore(this.getBestPrintableNode(aST5, true));
                this.print(aST5);
                break;
            }
            case 87: {
                this.out.print("while");
                this.dumpHiddenAfter(aST);
                this.printChildren(aST);
                break;
            }
            case 88: {
                this.out.print("do");
                this.dumpHiddenAfter(aST);
                this.print(aST3);
                this.out.print("while");
                this.dumpHiddenBefore(this.getBestPrintableNode(aST4, false));
                this.print(aST4);
                break;
            }
            case 97: {
                this.out.print("try");
                this.dumpHiddenAfter(aST);
                this.printChildren(aST);
                break;
            }
            case 99: {
                this.out.print("catch");
                this.dumpHiddenAfter(aST);
                this.printChildren(aST);
                break;
            }
            case 98: {
                this.out.print("finally");
                this.dumpHiddenAfter(aST);
                this.printChildren(aST);
                break;
            }
            case 93: {
                this.out.print("throw");
                this.dumpHiddenAfter(aST);
                this.print(aST3);
                break;
            }
            case 111: {
                this.print(aST3);
                this.out.print("?");
                this.dumpHiddenAfter(aST);
                this.print(aST4);
                this.print(aST5);
                break;
            }
            case 58: {
                this.out.print(aST.getText());
                this.dumpHiddenAfter(aST);
                break;
            }
            case 156: {
                this.out.print("int");
                this.dumpHiddenAfter(aST);
                break;
            }
            case 155: {
                if (aST.getText().length() != 6) {
                    System.err.println("Internal error: incorrect length of webcolor literal should have been detected sooner.");
                    break;
                }
                this.out.print("0xff" + aST.getText());
                this.dumpHiddenAfter(aST);
                break;
            }
            case 153: {
                AST aST11 = aST3;
                AST aST12 = aST3.getFirstChild();
                AST aST13 = aST4;
                String string = aST12.getText();
                this.out.print("PApplet.parse" + Character.toUpperCase(string.charAt(0)) + string.substring(1));
                this.dumpHiddenAfter(aST12);
                this.print(aST13);
                break;
            }
            case 144: {
                this.out.print(aST.getText());
                if (Preferences.getBoolean("preproc.substitute_floats")) {
                    this.out.print("f");
                }
                this.dumpHiddenAfter(aST);
                break;
            }
            default: {
                this.debug.println("Invalid type:" + aST.getType());
            }
        }
        this.stack.pop();
    }

    static {
        PdeEmitter.setupTokenNames();
    }
}

